/*
 * Decompiled with CFR 0.152.
 */
package play.api.libs.json.jackson;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import java.io.InputStream;
import java.io.Serializable;
import java.io.StringWriter;
import play.api.libs.json.JsValue;
import play.api.libs.json.JsonParserSettings$;
import play.api.libs.json.jackson.PlayJsonModule;
import scala.Function1;
import scala.runtime.BoxedUnit;

public final class JacksonJson$ {
    public static final JacksonJson$ MODULE$ = new JacksonJson$();
    private static ObjectMapper mapper;
    private static JsonFactory jsonFactory;
    private static volatile byte bitmap$0;

    private ObjectMapper mapper$lzycompute() {
        JacksonJson$ jacksonJson$ = this;
        synchronized (jacksonJson$) {
            if ((byte)(bitmap$0 & 1) == 0) {
                mapper = new ObjectMapper().registerModule(new PlayJsonModule(JsonParserSettings$.MODULE$.settings()));
                bitmap$0 = (byte)(bitmap$0 | 1);
            }
        }
        return mapper;
    }

    private ObjectMapper mapper() {
        return (byte)(bitmap$0 & 1) == 0 ? this.mapper$lzycompute() : mapper;
    }

    private JsonFactory jsonFactory$lzycompute() {
        JacksonJson$ jacksonJson$ = this;
        synchronized (jacksonJson$) {
            if ((byte)(bitmap$0 & 2) == 0) {
                jsonFactory = new JsonFactory(this.mapper());
                bitmap$0 = (byte)(bitmap$0 | 2);
            }
        }
        return jsonFactory;
    }

    private JsonFactory jsonFactory() {
        return (byte)(bitmap$0 & 2) == 0 ? this.jsonFactory$lzycompute() : jsonFactory;
    }

    private JsonGenerator stringJsonGenerator(StringWriter out) {
        return this.jsonFactory().createGenerator(out);
    }

    public JsValue parseJsValue(byte[] data) {
        return this.mapper().readValue(this.jsonFactory().createParser(data), JsValue.class);
    }

    public JsValue parseJsValue(String input) {
        return this.mapper().readValue(this.jsonFactory().createParser(input), JsValue.class);
    }

    public JsValue parseJsValue(InputStream stream) {
        return this.mapper().readValue(this.jsonFactory().createParser(stream), JsValue.class);
    }

    private <T> T withStringWriter(Function1<StringWriter, T> f) {
        T t;
        block10: {
            T t2;
            StringWriter sw = new StringWriter();
            try {
                t2 = f.apply(sw);
            }
            catch (Throwable throwable) {
                if (sw != null) {
                    try {
                        sw.close();
                    }
                    catch (Throwable throwable2) {}
                }
                throw throwable;
            }
            t = t2;
            if (sw == null) break block10;
            try {
                sw.close();
            }
            catch (Throwable throwable) {}
        }
        return t;
    }

    public String generateFromJsValue(JsValue jsValue, boolean escapeNonASCII) {
        return (String)this.withStringWriter((Function1<StringWriter, String> & Serializable)sw -> {
            JsonGenerator gen = MODULE$.stringJsonGenerator((StringWriter)sw);
            Object object = escapeNonASCII ? gen.enable(JsonGenerator.Feature.ESCAPE_NON_ASCII) : BoxedUnit.UNIT;
            MODULE$.mapper().writeValue(gen, (Object)jsValue);
            sw.flush();
            return sw.getBuffer().toString();
        });
    }

    public String prettyPrint(JsValue jsValue) {
        return (String)this.withStringWriter((Function1<StringWriter, String> & Serializable)sw -> {
            JsonGenerator gen = MODULE$.stringJsonGenerator((StringWriter)sw).setPrettyPrinter(new DefaultPrettyPrinter());
            ObjectWriter writer = MODULE$.mapper().writerWithDefaultPrettyPrinter();
            writer.writeValue(gen, (Object)jsValue);
            sw.flush();
            return sw.getBuffer().toString();
        });
    }

    public byte[] jsValueToBytes(JsValue jsValue) {
        return this.mapper().writeValueAsBytes(jsValue);
    }

    public JsonNode jsValueToJsonNode(JsValue jsValue) {
        return this.mapper().valueToTree(jsValue);
    }

    public JsValue jsonNodeToJsValue(JsonNode jsonNode) {
        return this.mapper().treeToValue(jsonNode, JsValue.class);
    }

    private JacksonJson$() {
    }
}

