/*
 * Decompiled with CFR 0.152.
 */
package play.api.libs.json;

import java.io.Serializable;
import java.math.MathContext;
import play.api.libs.json.BigDecimalParseSettings;
import play.api.libs.json.BigDecimalSerializerSettings;
import play.api.libs.json.JsonParserSettings;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.StringOps$;
import scala.math.BigDecimal;
import scala.math.BigDecimal$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.sys.package$;
import scala.util.control.NonFatal$;

public final class JsonParserSettings$
implements Serializable {
    public static final JsonParserSettings$ MODULE$ = new JsonParserSettings$();
    private static final MathContext defaultMathContext = MathContext.DECIMAL128;
    private static final int defaultScaleLimit = 6178;
    private static final int defaultDigitsLimit = 310;
    private static final BigDecimal MaxPlain = BigDecimal$.MODULE$.double2bigDecimal(1.0E20);
    private static final BigDecimal MinPlain = BigDecimal$.MODULE$.double2bigDecimal(1.0E-10);
    private static final JsonParserSettings settings;

    static {
        int scaleLimit = BoxesRunTime.unboxToInt(MODULE$.parseNum("play.json.parser.scaleLimit", BoxesRunTime.boxToInteger(MODULE$.defaultScaleLimit()), (Function1<String, Object> & Serializable)x$1 -> BoxesRunTime.boxToInteger(StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(x$1)))));
        int digitsLimit = BoxesRunTime.unboxToInt(MODULE$.parseNum("play.json.parser.digitsLimit", BoxesRunTime.boxToInteger(MODULE$.defaultDigitsLimit()), (Function1<String, Object> & Serializable)x$2 -> BoxesRunTime.boxToInteger(StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(x$2)))));
        MathContext mathContext = MODULE$.parseMathContext("play.json.parser.mathContext");
        BigDecimal minPlain = MODULE$.parseNum("play.json.serializer.minPlain", MODULE$.MinPlain(), (Function1<String, BigDecimal> & Serializable)s -> scala.package$.MODULE$.BigDecimal().exact((String)s));
        BigDecimal maxPlain = MODULE$.parseNum("play.json.serializer.maxPlain", MODULE$.MaxPlain(), (Function1<String, BigDecimal> & Serializable)s -> scala.package$.MODULE$.BigDecimal().exact((String)s));
        settings = new JsonParserSettings(new BigDecimalParseSettings(mathContext, scaleLimit, digitsLimit), new BigDecimalSerializerSettings(minPlain, maxPlain));
    }

    public MathContext defaultMathContext() {
        return defaultMathContext;
    }

    public int defaultScaleLimit() {
        return defaultScaleLimit;
    }

    public int defaultDigitsLimit() {
        return defaultDigitsLimit;
    }

    public BigDecimal MaxPlain() {
        return MaxPlain;
    }

    public BigDecimal MinPlain() {
        return MinPlain;
    }

    public JsonParserSettings apply() {
        return new JsonParserSettings(new BigDecimalParseSettings(this.defaultMathContext(), this.defaultScaleLimit(), this.defaultDigitsLimit()), new BigDecimalSerializerSettings(this.MinPlain(), this.MaxPlain()));
    }

    public JsonParserSettings settings() {
        return settings;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private MathContext parseMathContext(String key) {
        String string;
        String string2;
        boolean bl = false;
        Some some = null;
        Option option = package$.MODULE$.props().get(key).map((Function1<String, String> & Serializable)x$3 -> x$3.toLowerCase());
        if (option instanceof Some) {
            bl = true;
            some = (Some)option;
            String string3 = (String)some.value();
            if ("decimal128".equals(string3)) {
                return MathContext.DECIMAL128;
            }
        }
        if (bl && "decimal64".equals(string2 = (String)some.value())) {
            return MathContext.DECIMAL64;
        }
        if (bl && "decimal32".equals(string = (String)some.value())) {
            return MathContext.DECIMAL32;
        }
        if (!bl) return this.defaultMathContext();
        String string4 = (String)some.value();
        if (!"unlimited".equals(string4)) return this.defaultMathContext();
        return MathContext.UNLIMITED;
    }

    private <T> T parseNum(String key, T t, Function1<String, T> f) {
        Object object;
        try {
            object = package$.MODULE$.props().get(key).map(f).getOrElse((Function0<Object> & Serializable)() -> t);
        }
        catch (Throwable throwable) {
            Option<Throwable> option;
            Throwable throwable2 = throwable;
            if (throwable2 == null || (option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                throw throwable;
            }
            Object t2 = t;
            object = t2;
        }
        return (T)object;
    }

    public JsonParserSettings apply(BigDecimalParseSettings bigDecimalParseSettings, BigDecimalSerializerSettings bigDecimalSerializerSettings) {
        return new JsonParserSettings(bigDecimalParseSettings, bigDecimalSerializerSettings);
    }

    public Option<Tuple2<BigDecimalParseSettings, BigDecimalSerializerSettings>> unapply(JsonParserSettings x$0) {
        return x$0 == null ? None$.MODULE$ : new Some<Tuple2<BigDecimalParseSettings, BigDecimalSerializerSettings>>(new Tuple2<BigDecimalParseSettings, BigDecimalSerializerSettings>(x$0.bigDecimalParseSettings(), x$0.bigDecimalSerializerSettings()));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(JsonParserSettings$.class);
    }

    private JsonParserSettings$() {
    }
}

