/*
 * Decompiled with CFR 0.152.
 */
package play.api.libs.json;

import java.io.Serializable;
import play.api.libs.json.JsArray;
import play.api.libs.json.JsArray$;
import play.api.libs.json.JsBoolean$;
import play.api.libs.json.JsError;
import play.api.libs.json.JsNumber;
import play.api.libs.json.JsObject;
import play.api.libs.json.JsObject$;
import play.api.libs.json.JsPath;
import play.api.libs.json.JsPath$;
import play.api.libs.json.JsString;
import play.api.libs.json.JsValue;
import play.api.libs.json.JsonValidationError;
import play.api.libs.json.JsonValidationError$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Predef$ArrowAssoc$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IndexedSeq;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Nil$;
import scala.math.BigDecimal$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;

public final class JsError$
implements Serializable {
    public static final JsError$ MODULE$ = new JsError$();

    public JsError apply() {
        return new JsError((Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(JsPath$.MODULE$), Seq$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$))})));
    }

    public JsError apply(JsonValidationError error) {
        return new JsError((Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(JsPath$.MODULE$), Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new JsonValidationError[]{error})))})));
    }

    public JsError apply(String error) {
        return this.apply(JsonValidationError$.MODULE$.apply(error, (scala.collection.immutable.Seq<Object>)Nil$.MODULE$));
    }

    public JsError apply(Tuple2<JsPath, JsonValidationError> error) {
        return new JsError((Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(error._1()), Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new JsonValidationError[]{error._2()})))})));
    }

    public JsError apply(JsPath path, JsonValidationError error) {
        return this.apply(Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(path), error));
    }

    public JsError apply(JsPath path, String error) {
        return this.apply(Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(path), JsonValidationError$.MODULE$.apply(error, (scala.collection.immutable.Seq<Object>)Nil$.MODULE$)));
    }

    public Seq<Tuple2<JsPath, Seq<JsonValidationError>>> merge(Seq<Tuple2<JsPath, Seq<JsonValidationError>>> e1, Seq<Tuple2<JsPath, Seq<JsonValidationError>>> e2) {
        return ((IterableOps)e1.$plus$plus(e2)).groupBy((Function1<Tuple2, JsPath> & Serializable)x$1 -> (JsPath)x$1._1()).mapValues((Function1<Seq, Seq> & Serializable)x$2 -> (Seq)x$2.flatMap((Function1<Tuple2, Seq> & Serializable)x$3 -> (Seq)x$3._2())).toList();
    }

    public JsError merge(JsError e1, JsError e2) {
        return new JsError(this.merge(e1.errors(), e2.errors()));
    }

    public JsObject toJson(JsError e) {
        return this.toJson(e.errors(), false);
    }

    public JsObject toJson(Seq<Tuple2<JsPath, Seq<JsonValidationError>>> errors) {
        return this.toJson(errors, false);
    }

    public Seq<Tuple2<String, Seq<JsonValidationError>>> toFlatForm(JsError e) {
        return (Seq)e.errors().map((Function1<Tuple2, Tuple2> & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            JsPath path = (JsPath)tuple2._1();
            Seq seq = (Seq)tuple2._2();
            Tuple2<String, Seq> tuple22 = Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(path.toJsonString()), seq);
            return tuple22;
        });
    }

    private JsObject toJson(Seq<Tuple2<JsPath, Seq<JsonValidationError>>> errors, boolean flat) {
        return errors.foldLeft(JsObject$.MODULE$.empty(), (Function2<JsObject, Tuple2, JsObject> & Serializable)(obj, error) -> obj.$plus$plus(JsObject$.MODULE$.apply((Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(((JsPath)error._1()).toJsonString()), ((IterableOnceOps)error._2()).foldLeft(JsArray$.MODULE$.empty(), (Function2<JsArray, JsonValidationError, JsArray> & Serializable)(arr, err) -> {
            JsArray msg = new JsArray((IndexedSeq<JsValue>)Predef$.MODULE$.wrapRefArray(flat ? (Object[])new JsString[]{new JsString(err.message())} : (Object[])((IterableOnceOps)err.messages().map((Function1<String, JsString> & Serializable)x$4 -> new JsString((String)x$4))).toArray(ClassTag$.MODULE$.apply(JsValue.class))));
            return arr.$colon$plus(JsObject$.MODULE$.apply((Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("msg"), msg), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("args"), new JsArray((IndexedSeq<JsValue>)Predef$.MODULE$.wrapRefArray((Object[])((IterableOnceOps)err.args().map((Function1<Object, JsValue> & Serializable)a -> MODULE$.toJson(a))).toArray(ClassTag$.MODULE$.apply(JsValue.class)))))}))));
        }))})))));
    }

    private JsValue toJson(Object a) {
        JsValue jsValue;
        Object object = a;
        if (object instanceof String) {
            String string = (String)object;
            jsValue = new JsString(string);
        } else if (object instanceof Integer) {
            int n = BoxesRunTime.unboxToInt(object);
            jsValue = new JsNumber(BigDecimal$.MODULE$.int2bigDecimal(n));
        } else if (object instanceof Short) {
            short s = BoxesRunTime.unboxToShort(object);
            jsValue = new JsNumber(BigDecimal$.MODULE$.int2bigDecimal(s));
        } else if (object instanceof Long) {
            long l = BoxesRunTime.unboxToLong(object);
            jsValue = new JsNumber(BigDecimal$.MODULE$.long2bigDecimal(l));
        } else if (object instanceof Double) {
            double d = BoxesRunTime.unboxToDouble(object);
            jsValue = new JsNumber(BigDecimal$.MODULE$.double2bigDecimal(d));
        } else if (object instanceof Float) {
            float f = BoxesRunTime.unboxToFloat(object);
            jsValue = new JsNumber(BigDecimal$.MODULE$.double2bigDecimal(f));
        } else if (object instanceof Boolean) {
            boolean bl = BoxesRunTime.unboxToBoolean(object);
            jsValue = JsBoolean$.MODULE$.apply(bl);
        } else if (object instanceof JsValue) {
            JsValue jsValue2 = (JsValue)object;
            jsValue = jsValue2;
        } else {
            jsValue = new JsString(object.toString());
        }
        return jsValue;
    }

    public JsError apply(Seq<Tuple2<JsPath, Seq<JsonValidationError>>> errors) {
        return new JsError(errors);
    }

    public Option<Seq<Tuple2<JsPath, Seq<JsonValidationError>>>> unapply(JsError x$0) {
        return x$0 == null ? None$.MODULE$ : new Some<Seq<Tuple2<JsPath, Seq<JsonValidationError>>>>(x$0.errors());
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(JsError$.class);
    }

    private JsError$() {
    }
}

