/*
 * Decompiled with CFR 0.152.
 */
package org.rogach.scallop.tokenize;

import java.io.Serializable;
import org.rogach.scallop.tokenize.EOF;
import org.rogach.scallop.tokenize.Failed$;
import org.rogach.scallop.tokenize.Matched;
import org.rogach.scallop.tokenize.StringView;
import org.rogach.scallop.tokenize.TokenizationResult;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.collection.immutable.$colon$colon;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.runtime.ScalaRunTime$;

public final class ArgumentTokenizer$ {
    public static final ArgumentTokenizer$ MODULE$ = new ArgumentTokenizer$();
    private static final Function1<StringView, TokenizationResult> inputEnd = (Function1<StringView, TokenizationResult> & Serializable)input -> input.length() == 0 ? new Matched(package$.MODULE$.Nil(), (StringView)input) : Failed$.MODULE$;
    private static final Function1<StringView, TokenizationResult> whitespace = (Function1<StringView, TokenizationResult> & Serializable)input -> {
        int i;
        int l = input.length();
        for (i = 0; i < l && Character.isWhitespace(input.charAt(i)); ++i) {
        }
        return i == 0 ? Failed$.MODULE$ : new Matched(package$.MODULE$.Nil(), input.substring(i));
    };
    private static final Function1<StringView, TokenizationResult> singleQuotedString = (Function1<StringView, TokenizationResult> & Serializable)input -> {
        int stringEnd;
        return input.length() == 0 || input.charAt(0) != '\'' ? Failed$.MODULE$ : ((stringEnd = input.indexOf(39, 1)) == -1 ? new EOF("'") : new Matched((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{input.extract(1, stringEnd)})), input.substring(stringEnd + 1)));
    };
    private static final Function1<StringView, TokenizationResult> doubleQuotedString = (Function1<StringView, TokenizationResult> & Serializable)input -> {
        TokenizationResult tokenizationResult;
        if (input.length() == 0 || input.charAt(0) != '\"') {
            tokenizationResult = Failed$.MODULE$;
        } else {
            int i = 1;
            int s = 1;
            int l = input.length();
            StringBuilder b = new StringBuilder();
            boolean bl = false;
            boolean eofEscaped = false;
            boolean stringClosed = false;
            while (!bl && i < l) {
                while (i < l && input.charAt(i) != '\\' && input.charAt(i) != '\"') {
                    ++i;
                }
                b.append(input.extract(s, i));
                s = i;
                if (i >= l) continue;
                if (input.charAt(i) == '\\') {
                    if (i + 1 < l) {
                        StringBuilder stringBuilder = input.charAt(i + 1) == '\\' || input.charAt(i + 1) == '\"' ? b.append(input.charAt(i + 1)) : b.append(input.extract(i, i + 2));
                        s = i += 2;
                        continue;
                    }
                    eofEscaped = true;
                    bl = true;
                    continue;
                }
                if (input.charAt(i) == '\"') {
                    stringClosed = true;
                    bl = true;
                    continue;
                }
                b.append(input.charAt(i));
                s = ++i;
            }
            tokenizationResult = eofEscaped ? new EOF("escaped char") : (!stringClosed ? new EOF("\"") : new Matched((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{b.toString()})), input.substring(i + 1)));
        }
        return tokenizationResult;
    };
    private static final Function1<StringView, TokenizationResult> plainArgument = (Function1<StringView, TokenizationResult> & Serializable)input -> {
        int i = 0;
        int s = 0;
        int l = input.length();
        StringBuilder b = new StringBuilder();
        boolean bl = false;
        boolean eofEscaped = false;
        while (!bl && i < l) {
            while (i < l && !Character.isWhitespace(input.charAt(i)) && input.charAt(i) != '\\' && input.charAt(i) != '\"' && input.charAt(i) != '\'') {
                ++i;
            }
            b.append(input.extract(s, i));
            s = i;
            if (i >= l) continue;
            if (Character.isWhitespace(input.charAt(i))) {
                bl = true;
                continue;
            }
            if (input.charAt(i) == '\\') {
                if (i + 1 < l) {
                    b.append(input.charAt(i + 1));
                    s = i += 2;
                    continue;
                }
                eofEscaped = true;
                bl = true;
                continue;
            }
            bl = true;
        }
        return eofEscaped ? new EOF("escaped char") : (b.length() == 0 ? Failed$.MODULE$ : new Matched((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{b.toString()})), input.substring(i)));
    };
    private static final Function1<StringView, TokenizationResult> token = MODULE$.mapResult(MODULE$.repeat(MODULE$.alternatives((List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Function1[]{MODULE$.singleQuotedString(), MODULE$.doubleQuotedString(), MODULE$.plainArgument()})))), (Function1<Seq<String>, Seq<String>>)(Function1<Seq, Seq> & Serializable)tokens -> (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{tokens.mkString("")})));
    private static final Function1<StringView, TokenizationResult> argumentsParser = MODULE$.alternatives((List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Function1[]{MODULE$.seq(MODULE$.seq(MODULE$.repeat(MODULE$.seq(MODULE$.optional(MODULE$.whitespace()), MODULE$.token())), MODULE$.optional(MODULE$.whitespace())), MODULE$.inputEnd()), MODULE$.seq(MODULE$.optional(MODULE$.whitespace()), MODULE$.inputEnd())})));

    public TokenizationResult tokenize(String input) {
        return this.argumentsParser().apply(new StringView(input, 0));
    }

    private Function1<StringView, TokenizationResult> inputEnd() {
        return inputEnd;
    }

    private Function1<StringView, TokenizationResult> optional(Function1<StringView, TokenizationResult> parser) {
        return (Function1<StringView, TokenizationResult> & Serializable)input -> {
            TokenizationResult tokenizationResult = (TokenizationResult)parser.apply((StringView)input);
            TokenizationResult tokenizationResult2 = Failed$.MODULE$.equals(tokenizationResult) ? new Matched(package$.MODULE$.Nil(), (StringView)input) : tokenizationResult;
            return tokenizationResult2;
        };
    }

    private Function1<StringView, TokenizationResult> seq(Function1<StringView, TokenizationResult> parser1, Function1<StringView, TokenizationResult> parser2) {
        return (Function1<StringView, TokenizationResult> & Serializable)input -> {
            TokenizationResult tokenizationResult;
            TokenizationResult tokenizationResult2 = (TokenizationResult)parser1.apply((StringView)input);
            if (tokenizationResult2 instanceof EOF) {
                EOF eOF;
                tokenizationResult = eOF = (EOF)tokenizationResult2;
            } else if (Failed$.MODULE$.equals(tokenizationResult2)) {
                tokenizationResult = Failed$.MODULE$;
            } else if (tokenizationResult2 instanceof Matched) {
                TokenizationResult tokenizationResult3;
                Matched matched = (Matched)tokenizationResult2;
                Seq<String> tokens1 = matched.tokens();
                StringView rest1 = matched.rest();
                TokenizationResult tokenizationResult4 = (TokenizationResult)parser2.apply(rest1);
                if (tokenizationResult4 instanceof Matched) {
                    Matched matched2 = (Matched)tokenizationResult4;
                    Seq<String> tokens2 = matched2.tokens();
                    StringView rest2 = matched2.rest();
                    tokenizationResult3 = new Matched((Seq)tokens1.$plus$plus(tokens2), rest2);
                } else {
                    tokenizationResult3 = tokenizationResult4;
                }
                tokenizationResult = tokenizationResult3;
            } else {
                throw new MatchError(tokenizationResult2);
            }
            return tokenizationResult;
        };
    }

    private Function1<StringView, TokenizationResult> repeat(Function1<StringView, TokenizationResult> parser) {
        return (Function1<StringView, TokenizationResult> & Serializable)input -> MODULE$.repeatImpl(parser, (StringView)input, package$.MODULE$.Nil());
    }

    private TokenizationResult repeatImpl(Function1<StringView, TokenizationResult> parser, StringView input, List<Seq<String>> acc) {
        TokenizationResult tokenizationResult;
        block3: {
            TokenizationResult tokenizationResult2;
            while (true) {
                if ((tokenizationResult2 = parser.apply(input)) instanceof EOF) {
                    EOF eOF;
                    tokenizationResult = eOF = (EOF)tokenizationResult2;
                    break block3;
                }
                if (Failed$.MODULE$.equals(tokenizationResult2)) {
                    tokenizationResult = acc.isEmpty() ? Failed$.MODULE$ : new Matched((Seq)((List)acc.reverse()).flatten(Predef$.MODULE$.$conforms()), input);
                    break block3;
                }
                if (!(tokenizationResult2 instanceof Matched)) break;
                Matched matched = (Matched)tokenizationResult2;
                Seq<String> tokens = matched.tokens();
                StringView remainingInput = matched.rest();
                Seq<String> seq = tokens;
                acc = acc.$colon$colon(seq);
                input = remainingInput;
            }
            throw new MatchError(tokenizationResult2);
        }
        return tokenizationResult;
    }

    private Function1<StringView, TokenizationResult> alternatives(List<Function1<StringView, TokenizationResult>> parsers) {
        return (Function1<StringView, TokenizationResult> & Serializable)input -> MODULE$.alternativesImpl(parsers, (StringView)input);
    }

    private TokenizationResult alternativesImpl(List<Function1<StringView, TokenizationResult>> parsers, StringView input) {
        TokenizationResult tokenizationResult;
        block5: {
            List<Function1<StringView, TokenizationResult>> list;
            block6: {
                TokenizationResult tokenizationResult2;
                block7: {
                    TokenizationResult tokenizationResult3;
                    while (true) {
                        list = parsers;
                        Nil$ nil$ = package$.MODULE$.Nil();
                        List<Function1<StringView, TokenizationResult>> list2 = list;
                        if (!(nil$ != null ? !((Object)nil$).equals(list2) : list2 != null)) {
                            tokenizationResult = Failed$.MODULE$;
                            break block5;
                        }
                        if (!(list instanceof $colon$colon)) break block6;
                        $colon$colon $colon$colon = ($colon$colon)list;
                        Function1 parser = (Function1)$colon$colon.head();
                        List remainingParsers = $colon$colon.next$access$1();
                        tokenizationResult3 = (TokenizationResult)parser.apply(input);
                        if (tokenizationResult3 instanceof EOF) {
                            EOF eOF;
                            tokenizationResult2 = eOF = (EOF)tokenizationResult3;
                            break block7;
                        }
                        if (!Failed$.MODULE$.equals(tokenizationResult3)) break;
                        parsers = remainingParsers;
                    }
                    if (tokenizationResult3 instanceof Matched) {
                        Matched matched = (Matched)tokenizationResult3;
                        tokenizationResult2 = matched;
                    } else {
                        throw new MatchError(tokenizationResult3);
                    }
                }
                tokenizationResult = tokenizationResult2;
                break block5;
            }
            throw new MatchError(list);
        }
        return tokenizationResult;
    }

    private Function1<StringView, TokenizationResult> mapResult(Function1<StringView, TokenizationResult> parser, Function1<Seq<String>, Seq<String>> fn) {
        return (Function1<StringView, TokenizationResult> & Serializable)input -> {
            TokenizationResult tokenizationResult;
            TokenizationResult tokenizationResult2 = (TokenizationResult)parser.apply((StringView)input);
            if (tokenizationResult2 instanceof Matched) {
                Matched matched = (Matched)tokenizationResult2;
                Seq<String> tokens = matched.tokens();
                StringView rest = matched.rest();
                tokenizationResult = new Matched((Seq)fn.apply(tokens), rest);
            } else {
                tokenizationResult = tokenizationResult2;
            }
            return tokenizationResult;
        };
    }

    private Function1<StringView, TokenizationResult> whitespace() {
        return whitespace;
    }

    private Function1<StringView, TokenizationResult> singleQuotedString() {
        return singleQuotedString;
    }

    private Function1<StringView, TokenizationResult> doubleQuotedString() {
        return doubleQuotedString;
    }

    private Function1<StringView, TokenizationResult> plainArgument() {
        return plainArgument;
    }

    private Function1<StringView, TokenizationResult> token() {
        return token;
    }

    private Function1<StringView, TokenizationResult> argumentsParser() {
        return argumentsParser;
    }

    private ArgumentTokenizer$() {
    }
}

