/*
 * Decompiled with CFR 0.152.
 */
package org.opalj.util;

import java.io.Serializable;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import org.opalj.log.GlobalLogContext$;
import org.opalj.log.LogContext;
import org.opalj.log.OPALLogger$;
import org.opalj.util.Nanoseconds;
import org.opalj.util.Nanoseconds$;
import org.opalj.util.Return;
import org.opalj.util.package$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.AbstractIterable;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.math.Numeric$LongIsIntegral$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.DoubleRef;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;

public final class PerformanceEvaluation$ {
    public static final PerformanceEvaluation$ MODULE$ = new PerformanceEvaluation$();

    public <T> T memory(Function0<T> f, Function1<Object, BoxedUnit> mu, Option<LogContext> logContext) {
        MemoryMXBean memoryMXBean = ManagementFactory.getMemoryMXBean();
        package$.MODULE$.gc(memoryMXBean, package$.MODULE$.gc$default$2(), logContext);
        long usedBefore = memoryMXBean.getHeapMemoryUsage().getUsed();
        T r = f.apply();
        package$.MODULE$.gc(memoryMXBean, package$.MODULE$.gc$default$2(), logContext);
        long usedAfter = memoryMXBean.getHeapMemoryUsage().getUsed();
        mu.apply$mcVJ$sp(usedAfter - usedBefore);
        return r;
    }

    public <T> Option<LogContext> memory$default$3(Function0<T> f, Function1<Object, BoxedUnit> mu) {
        return None$.MODULE$;
    }

    public <T> T time(Function0<T> f, Function1<Nanoseconds, BoxedUnit> r) {
        T t;
        long startTime = System.nanoTime();
        try {
            t = f.apply();
        }
        finally {
            long endTime = System.nanoTime();
            r.apply(new Nanoseconds(Nanoseconds$.MODULE$.TimeSpan(startTime, endTime)));
        }
        T result2 = t;
        return result2;
    }

    public <T> Tuple2<Nanoseconds, T> timed(Function0<T> f) {
        long startTime = System.nanoTime();
        T result2 = f.apply();
        return new Tuple2<Nanoseconds, T>(new Nanoseconds(Nanoseconds$.MODULE$.TimeSpan(startTime, System.nanoTime())), result2);
    }

    public <T> T time(int epsilon, int consideredRunsEpsilon, int minimalNumberOfRelevantRuns, Function0<T> f, boolean runGC, Function2<Nanoseconds, Seq<Nanoseconds>, BoxedUnit> r) {
        Object t2;
        try {
            Predef$.MODULE$.require(minimalNumberOfRelevantRuns >= 3);
            Predef$.MODULE$.require(consideredRunsEpsilon > epsilon, (Function0<Object>)(Function0<String> & Serializable)() -> new StringBuilder(37).append("epsilon (").append(epsilon).append(") < consideredRunsEpsilon (").append(consideredRunsEpsilon).append(")").toString());
            ObjectRef<Integer> result2 = ObjectRef.create(BoxesRunTime.boxToInteger(0));
            double e = (double)epsilon / 100.0;
            double filterE = (double)(consideredRunsEpsilon + 100) / 100.0;
            IntRef runsSinceLastUpdate = IntRef.create(0);
            ObjectRef<Object> times = ObjectRef.create(scala.package$.MODULE$.List().empty());
            if (runGC) {
                MemoryMXBean x$1 = package$.MODULE$.gc$default$1();
                long x$2 = package$.MODULE$.gc$default$2();
                Option<LogContext> x$3 = package$.MODULE$.gc$default$3(x$1, x$2);
                package$.MODULE$.gc(x$1, x$2, x$3);
            }
            this.time(() -> {
                result$1.elem = f.apply();
            }, (Function1<Nanoseconds, BoxedUnit>)(Function1<Object, Object> & Serializable)t -> {
                PerformanceEvaluation$.$anonfun$time$4(times, r, result2, ((Nanoseconds)t).timeSpan());
                return BoxedUnit.UNIT;
            });
            DoubleRef avg = DoubleRef.create(((Nanoseconds)((List)times.elem).head()).timeSpan());
            do {
                if (runGC) {
                    MemoryMXBean x$4 = package$.MODULE$.gc$default$1();
                    long x$5 = package$.MODULE$.gc$default$2();
                    Option<LogContext> x$6 = package$.MODULE$.gc$default$3(x$4, x$5);
                    package$.MODULE$.gc(x$4, x$5, x$6);
                }
                this.time(() -> {
                    result$1.elem = f.apply();
                }, (Function1<Nanoseconds, BoxedUnit>)(Function1<Object, Object> & Serializable)t -> {
                    PerformanceEvaluation$.$anonfun$time$6(avg, filterE, times, runsSinceLastUpdate, minimalNumberOfRelevantRuns, r, ((Nanoseconds)t).timeSpan());
                    return BoxedUnit.UNIT;
                });
            } while (((List)times.elem).size() < minimalNumberOfRelevantRuns || Math.abs(avg.elem - (double)((Nanoseconds)((List)times.elem).head()).timeSpan()) > avg.elem * e);
            t2 = result2.elem;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable2 instanceof Return) {
                Object result3;
                Return return_ = (Return)throwable2;
                t2 = result3 = return_.t();
            }
            throw throwable;
        }
        return t2;
    }

    public <T> boolean time$default$5() {
        return false;
    }

    public <T, X> X run(Function0<T> f, Function2<Nanoseconds, T, X> r) {
        long startTime = System.nanoTime();
        T result2 = f.apply();
        long endTime = System.nanoTime();
        return r.apply(new Nanoseconds(Nanoseconds$.MODULE$.TimeSpan(startTime, endTime)), result2);
    }

    public static final /* synthetic */ void $anonfun$time$4(ObjectRef times$1, Function2 r$1, ObjectRef result$1, long t) {
        long l = t;
        times$1.elem = ((List)times$1.elem).$colon$colon(new Nanoseconds(l));
        if (t <= 999L) {
            r$1.apply(new Nanoseconds(t), (List)times$1.elem);
            OPALLogger$.MODULE$.warn("common", new StringBuilder(81).append("the time required by the function (").append(Nanoseconds$.MODULE$.toString$extension(t)).append(") ").append("is too small to get meaningful measurements.").toString(), GlobalLogContext$.MODULE$);
            throw new Return(result$1.elem);
        }
    }

    public static final /* synthetic */ boolean $anonfun$time$7(long t$1, double filterE$1, long x$1) {
        return (double)x$1 <= (double)t$1 * filterE$1;
    }

    public static final /* synthetic */ void $anonfun$time$6(DoubleRef avg$1, double filterE$1, ObjectRef times$1, IntRef runsSinceLastUpdate$1, int minimalNumberOfRelevantRuns$1, Function2 r$1, long t) {
        if ((double)t <= avg$1.elem * filterE$1) {
            long l = t;
            times$1.elem = ((List)((List)times$1.elem).filter((Function1<Object, Object> & Serializable)x$1 -> BoxesRunTime.boxToBoolean(PerformanceEvaluation$.$anonfun$time$7(t, filterE$1, ((Nanoseconds)x$1).timeSpan())))).$colon$colon(new Nanoseconds(l));
            avg$1.elem = (double)BoxesRunTime.unboxToLong(((AbstractIterable)((List)times$1.elem).map((Function1<Object, Object> & Serializable)x$2 -> BoxesRunTime.boxToLong(((Nanoseconds)x$2).timeSpan()))).sum(Numeric$LongIsIntegral$.MODULE$)) / (double)((List)times$1.elem).size();
            runsSinceLastUpdate$1.elem = 0;
        } else {
            ++runsSinceLastUpdate$1.elem;
            if (runsSinceLastUpdate$1.elem > minimalNumberOfRelevantRuns$1 * 2) {
                long l = t;
                times$1.elem = ((List)times$1.elem).$colon$colon(new Nanoseconds(l));
                avg$1.elem = (double)BoxesRunTime.unboxToLong(((AbstractIterable)((List)times$1.elem).map((Function1<Object, Object> & Serializable)x$3 -> BoxesRunTime.boxToLong(((Nanoseconds)x$3).timeSpan()))).sum(Numeric$LongIsIntegral$.MODULE$)) / (double)((List)times$1.elem).size();
                runsSinceLastUpdate$1.elem = 0;
            }
        }
        r$1.apply(new Nanoseconds(t), (List)times$1.elem);
    }

    private PerformanceEvaluation$() {
    }
}

