/*
 * Decompiled with CFR 0.152.
 */
package org.opalj.log;

import java.io.Serializable;
import org.opalj.log.ConsoleOPALLogger;
import org.opalj.log.ConsoleOPALLogger$;
import org.opalj.log.Error$;
import org.opalj.log.GlobalLogContext$;
import org.opalj.log.Info$;
import org.opalj.log.LogContext;
import org.opalj.log.LogMessage;
import org.opalj.log.OPALLogger;
import org.opalj.log.Warn$;
import scala.Function0;
import scala.Predef$;

public final class OPALLogger$
implements OPALLogger {
    public static final OPALLogger$ MODULE$ = new OPALLogger$();
    private static volatile OPALLogger[] loggers;
    private static int nextId;

    static {
        OPALLogger.$init$(MODULE$);
        loggers = new OPALLogger[32];
        nextId = 0;
    }

    @Override
    public final void logOnce(LogMessage message, LogContext ctx) {
        OPALLogger.logOnce$(this, message, ctx);
    }

    @Override
    public synchronized void updateLogger(LogContext ctx, OPALLogger logger) {
        int id = ctx.id();
        Predef$.MODULE$.assert(id != -1, (Function0<Object>)(Function0<String> & Serializable)() -> "context is not yet registered");
        Predef$.MODULE$.assert(id != -2, (Function0<Object>)(Function0<String> & Serializable)() -> "context is already unregistered");
        OPALLogger$.loggers[id] = logger;
    }

    @Override
    public synchronized void register(LogContext ctx, OPALLogger logger) {
        if (ctx.id() == -1) {
            int id = this.nextId();
            if (this.nextId() == loggers.length) {
                OPALLogger[] newLoggers = new OPALLogger[loggers.length * 2 + 1];
                System.arraycopy(loggers, 0, newLoggers, 0, loggers.length);
                loggers = newLoggers;
            }
            OPALLogger$.loggers[id] = logger;
            ctx.id_$eq(id);
            this.nextId_$eq(this.nextId() + 1);
            return;
        }
        if (ctx.id() >= 0) {
            throw new RuntimeException("reregistration of a log context is not supported");
        }
        throw new RuntimeException("log contexts cannot be reregistered");
    }

    @Override
    public OPALLogger register$default$2() {
        return new ConsoleOPALLogger(true, ConsoleOPALLogger$.MODULE$.$lessinit$greater$default$2());
    }

    @Override
    public synchronized void unregister(LogContext ctx) {
        LogContext logContext = ctx;
        GlobalLogContext$ globalLogContext$ = GlobalLogContext$.MODULE$;
        if (!(logContext != null ? !logContext.equals(globalLogContext$) : globalLogContext$ != null)) {
            String message = "unregistering the core global log context is not supported";
            throw new IllegalArgumentException(message);
        }
        int ctxId = ctx.id();
        if (ctxId + 1 == this.nextId()) {
            this.nextId_$eq(ctxId);
        }
        OPALLogger$.loggers[ctxId] = null;
        ctx.id_$eq(-2);
    }

    @Override
    public synchronized boolean isUnregistered(LogContext ctx) {
        return ctx.id() == -2;
    }

    @Override
    public OPALLogger logger(LogContext ctx) {
        OPALLogger oPALLogger;
        int ctxId = ctx.id();
        if (ctxId == -2) {
            if (GlobalLogContext$.MODULE$ == ctx) {
                throw new UnknownError("the global log context was unregistered");
            }
            throw new IllegalArgumentException(new StringBuilder(40).append("the log context ").append(ctx).append(" is already unregistered").toString());
        }
        OPALLogger$ oPALLogger$ = this;
        synchronized (oPALLogger$) {
            oPALLogger = loggers[ctxId];
        }
        return oPALLogger;
    }

    @Override
    public synchronized OPALLogger globalLogger() {
        return loggers[GlobalLogContext$.MODULE$.id()];
    }

    public int nextId() {
        return nextId;
    }

    public void nextId_$eq(int x$1) {
        nextId = x$1;
    }

    @Override
    public void log(LogMessage message, LogContext ctx) {
        this.logger(ctx).log(message, ctx);
    }

    @Override
    public final void debug(String category, String message, LogContext ctx) {
        this.log(Info$.MODULE$.apply(category, message), ctx);
    }

    @Override
    public final void debug(Function0<Object> p, String category, Function0<String> message, LogContext ctx) {
        if (p.apply$mcZ$sp()) {
            this.log(Info$.MODULE$.apply(category, message.apply()), ctx);
            return;
        }
    }

    @Override
    public final void info(String category, String message, LogContext ctx) {
        this.log(Info$.MODULE$.apply(category, message), ctx);
    }

    @Override
    public final void progress(String message, LogContext ctx) {
        this.log(Info$.MODULE$.apply("progress", message), ctx);
    }

    @Override
    public final void warn(String category, String message, LogContext ctx) {
        this.log(Warn$.MODULE$.apply(category, message), ctx);
    }

    @Override
    public final void error(String category, String message, LogContext ctx) {
        this.log(Error$.MODULE$.apply(category, message), ctx);
    }

    @Override
    public final void error(String category, String message, Throwable t, LogContext ctx) {
        this.log(Error$.MODULE$.apply(category, message, t), ctx);
    }

    private OPALLogger$() {
    }
}

