/*
 * Decompiled with CFR 0.152.
 */
package org.opalj.io;

import java.awt.Desktop;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.zip.GZIPOutputStream;
import org.opalj.io.OpeningFileFailedException;
import scala.Function1;
import scala.Predef$;
import scala.collection.IterableOnce;
import scala.collection.StringOps$;
import scala.collection.immutable.$colon$colon;
import scala.collection.immutable.Nil$;
import scala.io.Source;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.xml.Node;

public final class package$ {
    public static final package$ MODULE$ = new package$();

    public String sanitizeFileName(String fileName) {
        return StringOps$.MODULE$.take$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.filterNot$extension(Predef$.MODULE$.augmentString(fileName), (Function1<Object, Object> & Serializable)x$1 -> BoxesRunTime.boxToBoolean(package$.$anonfun$sanitizeFileName$1(BoxesRunTime.unboxToChar(x$1)))).replaceAll("[\\/:*?\"<>|\\[\\]=!@,]", "_")), 192);
    }

    public File writeAndOpen(Node node, String filenamePrefix, String filenameSuffix) throws IOException, OpeningFileFailedException {
        String data = node.toString();
        return this.writeAndOpen(data, filenamePrefix, filenameSuffix);
    }

    public File writeAndOpen(String data, String filenamePrefix, String filenameSuffix) throws IOException, OpeningFileFailedException {
        File file = this.write(data, filenamePrefix, filenameSuffix).toFile();
        this.open(file);
        return file;
    }

    public void open(File file) {
        try {
            Desktop.getDesktop().open(file);
        }
        catch (Throwable t) {
            throw new OpeningFileFailedException(file, t);
        }
    }

    public Path write(String data, String filenamePrefix, String filenameSuffix) {
        return this.write(new $colon$colon<Nothing$>((Nothing$)((Object)data), Nil$.MODULE$), filenamePrefix, filenameSuffix);
    }

    public Path write(IterableOnce<String> data, String filenamePrefix, String filenameSuffix) {
        Path path = Files.createTempFile(this.sanitizeFileName(filenamePrefix), this.sanitizeFileName(filenameSuffix), new FileAttribute[0]);
        this.write(data.iterator().map((Function1<String, byte[]> & Serializable)x$2 -> x$2.getBytes("UTF-8")), path);
        return path;
    }

    public Path writeGZip(String data, String filenamePrefix, String filenameSuffix) {
        return this.writeGZip(new $colon$colon<Nothing$>((Nothing$)((Object)data), Nil$.MODULE$), filenamePrefix, filenameSuffix);
    }

    public Path writeGZip(IterableOnce<String> data, String filenamePrefix, String filenameSuffix) {
        Path path = Files.createTempFile(this.sanitizeFileName(filenamePrefix), this.sanitizeFileName(filenameSuffix), new FileAttribute[0]);
        this.writeGZip(data.iterator().map((Function1<String, byte[]> & Serializable)x$3 -> x$3.getBytes("UTF-8")), path);
        return path;
    }

    public void write(byte[] data, Path path) {
        Files.write(path, data, new OpenOption[0]);
    }

    public void write(IterableOnce<byte[]> data, Path path) {
        try (FileOutputStream out = new FileOutputStream(path.toFile());){
            data.iterator().foreach((Function1<byte[], Object> & Serializable)x$1 -> {
                out.write(x$1);
                return BoxedUnit.UNIT;
            });
        }
    }

    public void writeGZip(byte[] data, Path path) {
        this.writeGZip(new $colon$colon<Nothing$>((Nothing$)data, Nil$.MODULE$), path);
    }

    public void writeGZip(IterableOnce<byte[]> data, Path path) {
        try (GZIPOutputStream out = new GZIPOutputStream(new FileOutputStream(path.toFile()));){
            data.iterator().foreach((Function1<byte[], Object> & Serializable)x$1 -> {
                out.write(x$1);
                return BoxedUnit.UNIT;
            });
        }
    }

    public <C extends Closeable, T> T process(C closable, Function1<C, T> r) {
        T t;
        try {
            t = r.apply(closable);
        }
        finally {
            if (closable != null) {
                closable.close();
            }
        }
        return t;
    }

    public <C extends Source, T> T processSource(C source, Function1<C, T> r) {
        T t;
        try {
            t = r.apply(source);
        }
        finally {
            if (source != null) {
                source.close();
            }
        }
        return t;
    }

    public static final /* synthetic */ boolean $anonfun$sanitizeFileName$1(char x$1) {
        return x$1 == ' ';
    }

    private package$() {
    }
}

