/*
 * Decompiled with CFR 0.152.
 */
package org.opalj.graphs;

import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import javax.script.Invocable;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import org.opalj.collection.IntIterator;
import org.opalj.collection.mutable.IntArrayStack;
import org.opalj.collection.mutable.IntArrayStack$;
import org.opalj.graphs.Graph;
import org.opalj.graphs.Node;
import org.opalj.log.GlobalLogContext$;
import org.opalj.log.OPALLogger$;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Predef$ArrowAssoc$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.Stack;
import scala.collection.mutable.Stack$;
import scala.reflect.ClassTag;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.Null$;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;

public final class package$ {
    public static final package$ MODULE$ = new package$();
    private static Function1<String, String> dotToSVG;
    private static volatile boolean bitmap$0;

    public byte[] toAdjacencyMatrix(int maxNodeId, Function1<Object, Set<Object>> successors) {
        int columns = (maxNodeId + 1) * 2;
        int rows = maxNodeId + 1;
        byte[] g = new byte[rows * columns];
        for (int r = 0; r <= maxNodeId; ++r) {
            Set<Object> s = successors.apply(BoxesRunTime.boxToInteger(r));
            int c = 0;
            while (c <= maxNodeId) {
                int i = r * columns + c * 2;
                int n = g[i] = s.contains(BoxesRunTime.boxToInteger(c)) ? 49 : 48;
                if (++c <= maxNodeId) {
                    g[i + 1] = 44;
                    continue;
                }
                g[i + 1] = 10;
            }
        }
        return g;
    }

    public String toDot(Iterable<Node> rootNodes, String dir, String ranksep, String fontname, String rankdir) {
        ObjectRef<Set> nodesToProcess = ObjectRef.create((Set)Predef$.MODULE$.Set().empty().$plus$plus(rootNodes));
        ObjectRef<Object> processedNodes = ObjectRef.create(Predef$.MODULE$.Set().empty());
        ObjectRef<String> s = ObjectRef.create(new StringBuilder(76).append("digraph G {\n").append("\tdir=").append(dir).append(";\n").append("\tranksep=").append(ranksep).append(";\n").append("\trankdir=").append(rankdir).append(";\n").append("\tnode [fontname=").append(fontname).append(",shape=rectangle];\n").toString());
        while (((Set)nodesToProcess.elem).nonEmpty()) {
            Node nextNode = (Node)((Set)nodesToProcess.elem).head();
            processedNodes.elem = (Set)((Set)processedNodes.elem).$plus(nextNode);
            nodesToProcess.elem = (Set)((Set)nodesToProcess.elem).tail();
            if (nextNode.toHRR().isDefined()) {
                Map visualProperties = nextNode.visualProperties();
                visualProperties = (Map)visualProperties.$plus(Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("label"), nextNode.toHRR().get().replace("\"", "\\\"").replace("\n", "\\l")));
                s.elem = new StringBuilder(1).append((String)s.elem).append("\t").append(nextNode.nodeId()).append(((IterableOnceOps)visualProperties.map((Function1<Tuple2, String> & Serializable)e -> new StringBuilder(5).append("\"").append(e._1()).append("\"=\"").append(e._2()).append("\"").toString())).mkString("[", ",", "];\n")).toString();
            }
            Function1<Node, Object> & Serializable f = (Function1<Node, Object> & Serializable)sn -> {
                package$.$anonfun$toDot$2(nextNode, s, dir, processedNodes, nodesToProcess, sn);
                return BoxedUnit.UNIT;
            };
            nextNode.foreachSuccessor((Function1<Node, BoxedUnit>)f);
        }
        s.elem = new StringBuilder(1).append((String)s.elem).append("}").toString();
        return (String)s.elem;
    }

    public String toDot$default$2() {
        return "forward";
    }

    public String toDot$default$3() {
        return "0.8";
    }

    public String toDot$default$4() {
        return "Helvetica";
    }

    public String toDot$default$5() {
        return "TB";
    }

    private Function1<String, String> dotToSVG$lzycompute() {
        package$ package$2 = this;
        synchronized (package$2) {
            if (!bitmap$0) {
                Invocable invocable;
                OPALLogger$.MODULE$.info("setup", "initialzing JavaScript engine for rendering dot graphics", GlobalLogContext$.MODULE$);
                ScriptEngineManager engineManager = new ScriptEngineManager();
                ScriptEngine engine = engineManager.getEngineByName("nashorn");
                try (InputStream visJS = null;){
                    visJS = this.getClass().getResourceAsStream("viz-lite.js");
                    BufferedReader reader = new BufferedReader(new InputStreamReader(visJS));
                    engine.eval(reader);
                    invocable = (Invocable)((Object)engine);
                }
                Invocable invocable2 = invocable;
                OPALLogger$.MODULE$.info("setup", "finished initialization of JavaScript engine for rendering dot graphics", GlobalLogContext$.MODULE$);
                dotToSVG = (Function1<String, String> & Serializable)dot -> invocable2.invokeFunction("Viz", dot).toString();
                bitmap$0 = true;
            }
        }
        return dotToSVG;
    }

    public final Function1<String, String> dotToSVG() {
        if (!bitmap$0) {
            return this.dotToSVG$lzycompute();
        }
        return dotToSVG;
    }

    public final <N> List<Iterable<N>> closedSCCs(Graph<N> g, ClassTag<N> evidence$1) {
        return this.closedSCCs((Iterable<N>)g.vertices(), g.asIterable(), evidence$1);
    }

    public <N> List<Iterable<N>> closedSCCs(Iterable<N> ns, Function1<N, Iterable<N>> es, ClassTag<N> evidence$2) {
        Object2IntOpenHashMap nDFSNums = new Object2IntOpenHashMap();
        int ProcessedNodeNum = -1;
        Null$ PathSegmentSeparator = null;
        Stack workstack = new Stack(8);
        ArrayBuffer path = new ArrayBuffer(16);
        ObjectRef<Object> cSCCs = ObjectRef.create(scala.package$.MODULE$.List().empty());
        IntRef nextDFSNum = IntRef.create(ProcessedNodeNum + 1);
        ns.foreach((Function1<Object, Object> & Serializable)n -> {
            package$.$anonfun$closedSCCs$4(nDFSNums, nextDFSNum, path, workstack, ProcessedNodeNum, PathSegmentSeparator, cSCCs, es, n);
            return BoxedUnit.UNIT;
        });
        return (List)cSCCs.elem;
    }

    public List<List<Object>> sccs(int ns, Function1<Object, IntIterator> es, boolean filterSingletons) {
        List<List<Integer>> sccs = scala.package$.MODULE$.List().empty();
        int[] nIndex = new int[ns + 1];
        int[] nLowLink = new int[ns + 1];
        boolean[] nOnStack = new boolean[ns + 1];
        int UndefinedIndex = 0;
        int index = 1;
        IntArrayStack s = new IntArrayStack(Math.max(8, ns / 4));
        for (int n = 0; n < ns; ++n) {
            if (nIndex[n] != UndefinedIndex) continue;
            IntArrayStack ws = IntArrayStack$.MODULE$.apply(n);
            Stack wsSuccessors = (Stack)Stack$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new IntIterator[]{null}));
            do {
                int n2 = ws.pop();
                IntIterator remainingSuccessors = (IntIterator)wsSuccessors.pop();
                if (remainingSuccessors == null) {
                    nIndex[n2] = index;
                    nLowLink[n2] = index++;
                    s.push(n2);
                    nOnStack[n2] = true;
                    remainingSuccessors = es.apply(BoxesRunTime.boxToInteger(n2));
                } else {
                    int w = ws.pop();
                    nLowLink[n2] = Math.min(nLowLink[n2], nLowLink[w]);
                }
                boolean bl = true;
                while (bl && remainingSuccessors.hasNext()) {
                    int w = remainingSuccessors.next();
                    if (nIndex[w] == UndefinedIndex) {
                        ws.push(w);
                        ws.push(n2);
                        wsSuccessors.push(remainingSuccessors);
                        ws.push(w);
                        wsSuccessors.push(null);
                        bl = false;
                        continue;
                    }
                    if (!nOnStack[w]) continue;
                    nLowLink[n2] = Math.min(nLowLink[n2], nLowLink[w]);
                }
                if (!bl || remainingSuccessors.hasNext() || nLowLink[n2] != nIndex[n2]) continue;
                List<Integer> nextSCC = scala.package$.MODULE$.List().empty();
                int w = -1;
                do {
                    w = s.pop();
                    nOnStack[w] = false;
                    nextSCC = nextSCC.$colon$colon(BoxesRunTime.boxToInteger(w));
                } while (n2 != w);
                if (filterSingletons && !((IterableOnceOps)nextSCC.tail()).nonEmpty() && !es.apply(BoxesRunTime.boxToInteger(n2)).exists(x$1 -> x$1 == n2)) continue;
                sccs = sccs.$colon$colon(nextSCC);
            } while (ws.nonEmpty());
        }
        return sccs;
    }

    public boolean sccs$default$3() {
        return false;
    }

    public List<Object> topologicalSort(Map<Object, List<Object>> graph) {
        ObjectRef<Object> sortedNodes = ObjectRef.create(scala.package$.MODULE$.List().empty());
        ObjectRef<Object> permanent = ObjectRef.create(Predef$.MODULE$.Set().empty());
        ObjectRef<Object> temporary = ObjectRef.create(Predef$.MODULE$.Set().empty());
        Map preparedGraph = (Map)graph.map((Function1<Tuple2, Tuple2> & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                int node = tuple2._1$mcI$sp();
                List deps = (List)tuple2._2();
                return Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(BoxesRunTime.boxToInteger(node)), deps.filter(x$2 -> x$2 != node));
            }
            throw new MatchError(tuple2);
        });
        preparedGraph.keys().foreach(node -> package$.visit$1(node, permanent, temporary, preparedGraph, sortedNodes));
        return (List)sortedNodes.elem;
    }

    public static final /* synthetic */ void $anonfun$toDot$2(Node nextNode$1, ObjectRef s$1, String dir$1, ObjectRef processedNodes$1, ObjectRef nodesToProcess$1, Node sn) {
        if (nextNode$1.toHRR().isDefined()) {
            s$1.elem = new StringBuilder(14).append((String)s$1.elem).append("\t").append(nextNode$1.nodeId()).append(" -> ").append(sn.nodeId()).append(" [dir=").append(dir$1).append("];\n").toString();
        }
        if (!((Set)processedNodes$1.elem).contains(sn)) {
            nodesToProcess$1.elem = (Set)((Set)nodesToProcess$1.elem).$plus(sn);
            return;
        }
    }

    private static final int dfsNum$1(Object n, Object2IntOpenHashMap nDFSNums$1) {
        return nDFSNums$1.getInt(n);
    }

    private static final void setDFSNum$1(Object n, int i, Object2IntOpenHashMap nDFSNums$1) {
        nDFSNums$1.put(n, i);
    }

    private static final boolean hasDFSNum$1(Object n, Object2IntOpenHashMap nDFSNums$1) {
        return nDFSNums$1.containsKey(n);
    }

    private static final void markPathAsProcessed$1(ArrayBuffer path$1, int ProcessedNodeNum$1, Object2IntOpenHashMap nDFSNums$1) {
        path$1.foreach((Function1<Object, Object> & Serializable)n -> {
            package$.setDFSNum$1(n, ProcessedNodeNum$1, nDFSNums$1);
            return BoxedUnit.UNIT;
        });
        path$1.clear();
    }

    private static final void addToPath$1(Object n, ArrayBuffer path$1, IntRef initialDFSNum$1, IntRef nextDFSNum$1, Object2IntOpenHashMap nDFSNums$1) {
        if (path$1.isEmpty()) {
            initialDFSNum$1.elem = nextDFSNum$1.elem;
        }
        path$1.$plus$eq(n);
        package$.setDFSNum$1(n, nextDFSNum$1.elem, nDFSNums$1);
        ++nextDFSNum$1.elem;
    }

    public static final /* synthetic */ boolean $anonfun$closedSCCs$3(int cSCCDFSNum$1, Object2IntOpenHashMap nDFSNums$1, Object succN) {
        return package$.hasDFSNum$1(succN, nDFSNums$1) && package$.dfsNum$1(succN, nDFSNums$1) == cSCCDFSNum$1;
    }

    public static final /* synthetic */ boolean $anonfun$closedSCCs$2(Function1 es$1, int cSCCDFSNum$1, Object2IntOpenHashMap nDFSNums$1, Object n) {
        return ((IterableOnceOps)es$1.apply(n)).forall((Function1<Object, Object> & Serializable)succN -> BoxesRunTime.boxToBoolean(package$.$anonfun$closedSCCs$3(cSCCDFSNum$1, nDFSNums$1, succN)));
    }

    private static final void dfs$1(Object initialN, IntRef nextDFSNum$1, ArrayBuffer path$1, Stack workstack$1, int ProcessedNodeNum$1, Null$ PathSegmentSeparator$1, ObjectRef cSCCs$1, Function1 es$1, Object2IntOpenHashMap nDFSNums$1) {
        IntRef initialDFSNum = IntRef.create(nextDFSNum$1.elem);
        path$1.clear();
        workstack$1.clear();
        workstack$1.push(initialN);
        while (workstack$1.nonEmpty()) {
            Object object;
            Object n2;
            Object a = n2 = workstack$1.pop();
            Object var11_11 = null;
            if (!(a != null ? !a.equals(var11_11) : var11_11 != null)) {
                Object n3 = workstack$1.pop();
                if (path$1.nonEmpty()) {
                    int nDFSNum = package$.dfsNum$1(n3, nDFSNums$1);
                    int cSCCDFSNum = package$.dfsNum$1(path$1.last(), nDFSNums$1);
                    Predef$.MODULE$.assert(cSCCDFSNum != ProcessedNodeNum$1);
                    if (nDFSNum != cSCCDFSNum) {
                        ArrayBuffer cSCC = (ArrayBuffer)path$1.drop(cSCCDFSNum - initialDFSNum.elem);
                        cSCCs$1.elem = ((List)cSCCs$1.elem).$colon$colon(cSCC);
                        package$.markPathAsProcessed$1(path$1, ProcessedNodeNum$1, nDFSNums$1);
                    } else if (workstack$1.isEmpty() || path$1.iterator().drop(cSCCDFSNum - initialDFSNum.elem).forall((Function1<Object, Object> & Serializable)n -> BoxesRunTime.boxToBoolean(package$.$anonfun$closedSCCs$2(es$1, cSCCDFSNum, nDFSNums$1, n)))) {
                        cSCCs$1.elem = ((List)cSCCs$1.elem).$colon$colon(path$1.drop(cSCCDFSNum - initialDFSNum.elem));
                        package$.markPathAsProcessed$1(path$1, ProcessedNodeNum$1, nDFSNums$1);
                    }
                }
                object = BoxedUnit.UNIT;
                continue;
            }
            if (package$.hasDFSNum$1(n2, nDFSNums$1)) {
                int nDFSNum = package$.dfsNum$1(n2, nDFSNums$1);
                if (nDFSNum < initialDFSNum.elem) {
                    package$.markPathAsProcessed$1(path$1, ProcessedNodeNum$1, nDFSNums$1);
                } else {
                    int startPathIndex = nDFSNum - initialDFSNum.elem;
                    int pathIndex = path$1.length() - 1;
                    if (package$.dfsNum$1(path$1.apply(pathIndex), nDFSNums$1) != nDFSNum) {
                        while (pathIndex >= startPathIndex) {
                            package$.setDFSNum$1(path$1.apply(pathIndex), nDFSNum, nDFSNums$1);
                            --pathIndex;
                        }
                    }
                }
                object = BoxedUnit.UNIT;
                continue;
            }
            package$.addToPath$1(n2, path$1, initialDFSNum, nextDFSNum$1, nDFSNums$1);
            Iterable succNs = (Iterable)es$1.apply(n2);
            if (succNs.nonEmpty()) {
                workstack$1.push(n2);
                workstack$1.push(null);
                object = workstack$1.prependAll((IterableOnce)succNs);
                continue;
            }
            package$.markPathAsProcessed$1(path$1, ProcessedNodeNum$1, nDFSNums$1);
            object = BoxedUnit.UNIT;
        }
        Predef$.MODULE$.assert(path$1.isEmpty());
    }

    public static final /* synthetic */ void $anonfun$closedSCCs$4(Object2IntOpenHashMap nDFSNums$1, IntRef nextDFSNum$1, ArrayBuffer path$1, Stack workstack$1, int ProcessedNodeNum$1, Null$ PathSegmentSeparator$1, ObjectRef cSCCs$1, Function1 es$1, Object n) {
        if (!package$.hasDFSNum$1(n, nDFSNums$1)) {
            package$.dfs$1(n, nextDFSNum$1, path$1, workstack$1, ProcessedNodeNum$1, PathSegmentSeparator$1, cSCCs$1, es$1, nDFSNums$1);
            return;
        }
    }

    private static final void visit$1(int node, ObjectRef permanent$1, ObjectRef temporary$1, Map preparedGraph$1, ObjectRef sortedNodes$1) {
        if (!((Set)permanent$1.elem).contains(BoxesRunTime.boxToInteger(node))) {
            if (((Set)temporary$1.elem).contains(BoxesRunTime.boxToInteger(node))) {
                throw new IllegalStateException("Graph contains a cycle");
            }
            temporary$1.elem = (Set)((Set)temporary$1.elem).$plus(BoxesRunTime.boxToInteger(node));
            ((List)preparedGraph$1.apply(BoxesRunTime.boxToInteger(node))).foreach(otherNode -> package$.visit$1(otherNode, permanent$1, temporary$1, preparedGraph$1, sortedNodes$1));
            permanent$1.elem = (Set)((Set)permanent$1.elem).$plus(BoxesRunTime.boxToInteger(node));
            temporary$1.elem = (Set)((Set)temporary$1.elem).$minus(BoxesRunTime.boxToInteger(node));
            sortedNodes$1.elem = (List)((List)sortedNodes$1.elem).$colon$plus(BoxesRunTime.boxToInteger(node));
            return;
        }
    }

    private package$() {
    }
}

