/*
 * Decompiled with CFR 0.152.
 */
package org.opalj.graphs;

import java.io.Serializable;
import org.opalj.collection.IntSet;
import org.opalj.collection.immutable.IntArraySet;
import org.opalj.collection.immutable.IntArraySet$;
import org.opalj.collection.mutable.IntArrayStack;
import org.opalj.graphs.AbstractDominatorTree;
import org.opalj.graphs.DominanceFrontiers;
import org.opalj.graphs.DominatorTree;
import org.opalj.graphs.PostDominatorTree;
import org.opalj.log.GlobalLogContext$;
import org.opalj.log.OPALLogger$;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;

public final class DominanceFrontiers$ {
    public static final DominanceFrontiers$ MODULE$ = new DominanceFrontiers$();

    public DominanceFrontiers apply(AbstractDominatorTree dt, Function1<Object, Object> isValidNode) {
        int startNode = dt.startNode();
        Function1<Object, Function1<Function1<Object, BoxedUnit>, BoxedUnit>> foreachSuccessorOf = dt.foreachSuccessorOf();
        int max = dt.maxNode() + 1;
        int potentialChildrenCount = 3;
        IntArrayStack[] children = new IntArrayStack[max];
        for (int i = 0; i < max; ++i) {
            if (!isValidNode.apply$mcZI$sp(i) || i == startNode) continue;
            int d = dt.idom()[i];
            IntArrayStack dChildren = children[d];
            if (dChildren == null) {
                IntArrayStack child = new IntArrayStack(potentialChildrenCount);
                child.push(i);
                children[d] = child;
                continue;
            }
            dChildren.push(i);
        }
        ObjectRef<IntArraySet[]> dfs = ObjectRef.create(new IntArraySet[max]);
        IntArrayStack inDFSOrder = new IntArrayStack(Math.max(max - 2, 2));
        ObjectRef<List> nodes = ObjectRef.create((List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{startNode})));
        while (((List)nodes.elem).nonEmpty()) {
            int n2 = BoxesRunTime.unboxToInt(((List)nodes.elem).head());
            nodes.elem = (List)((List)nodes.elem).tail();
            IntArrayStack nChildren = children[n2];
            if (nChildren != null) {
                inDFSOrder.push(n2);
                nChildren.foreach(x$5 -> {
                    nodes$1.elem = ((List)nodes$1.elem).$colon$colon(BoxesRunTime.boxToInteger(x$5));
                });
                continue;
            }
            ((IntArraySet[])dfs.elem)[n2] = DominanceFrontiers$.dfLocal$1(n2, foreachSuccessorOf, dt);
        }
        inDFSOrder.foreach(n -> {
            IntArraySet s2;
            ((IntArraySet[])dfs$1.elem)[n] = s2 = children[n].foldLeft(DominanceFrontiers$.dfLocal$1(n, foreachSuccessorOf, dt), (Function2<IntArraySet, Object, IntArraySet> & Serializable)(s, c) -> DominanceFrontiers$.$anonfun$apply$4(dfs, dt, n, s, BoxesRunTime.unboxToInt(c)));
        });
        if (dt.isAugmented()) {
            AbstractDominatorTree abstractDominatorTree = dt;
            if (abstractDominatorTree instanceof PostDominatorTree) {
                PostDominatorTree postDominatorTree = (PostDominatorTree)abstractDominatorTree;
                dfs.elem = (IntArraySet[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((IntArraySet[])dfs.elem), (Function1<IntArraySet, IntArraySet> & Serializable)e -> {
                    if (e != null) {
                        return (IntArraySet)e.$minus$minus((IntSet)postDominatorTree.additionalExitNodes());
                    }
                    return e;
                }, ClassTag$.MODULE$.apply(IntArraySet.class));
            } else if (abstractDominatorTree instanceof DominatorTree) {
            } else {
                OPALLogger$.MODULE$.warn("computing dominance frontier", new StringBuilder(50).append("the augmentation of ").append(abstractDominatorTree).append(" is not understood and ignored").toString(), GlobalLogContext$.MODULE$);
            }
        }
        return new DominanceFrontiers((IntArraySet[])dfs.elem);
    }

    private static final IntArraySet dfLocal$1(int n, Function1 foreachSuccessorOf$1, AbstractDominatorTree dt$1) {
        ObjectRef<IntArraySet> s = ObjectRef.create(IntArraySet$.MODULE$.empty());
        try {
            ((Function1)foreachSuccessorOf$1.apply(BoxesRunTime.boxToInteger(n))).apply(y -> {
                if (dt$1.dom(y) != n) {
                    s$2.elem = (IntArraySet)((IntArraySet)s$2.elem).$plus(y);
                    return;
                }
            });
        }
        catch (Throwable t) {
            throw new Throwable(new StringBuilder(41).append("failed iterating over successors of node ").append(n).toString(), t);
        }
        return (IntArraySet)s.elem;
    }

    public static final /* synthetic */ IntArraySet $anonfun$apply$5(AbstractDominatorTree dt$1, int n$2, IntArraySet s, int w) {
        if (!dt$1.strictlyDominates(n$2, w)) {
            return (IntArraySet)s.$plus(w);
        }
        return s;
    }

    public static final /* synthetic */ IntArraySet $anonfun$apply$4(ObjectRef dfs$1, AbstractDominatorTree dt$1, int n$2, IntArraySet s2, int c) {
        return ((IntArraySet[])dfs$1.elem)[c].foldLeft(s2, (Function2<IntArraySet, Object, IntArraySet> & Serializable)(s, w) -> DominanceFrontiers$.$anonfun$apply$5(dt$1, n$2, s, BoxesRunTime.unboxToInt(w)));
    }

    private DominanceFrontiers$() {
    }
}

