/*
 * Decompiled with CFR 0.152.
 */
package org.opalj.da;

import java.io.File;
import java.io.Serializable;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import org.apache.commons.text.similarity.LevenshteinDistance;
import org.opalj.da.ClassFile;
import org.opalj.da.ClassFile$;
import org.opalj.da.ClassFileReader$;
import org.opalj.io.package$;
import org.opalj.log.ConsoleOPALLogger;
import org.opalj.log.Error$;
import org.opalj.log.GlobalLogContext$;
import org.opalj.log.OPALLogger$;
import scala.Console$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.AbstractIterable;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.$colon$colon;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.Nothing$;
import scala.runtime.ObjectRef;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

public final class Disassembler$ {
    public static final Disassembler$ MODULE$ = new Disassembler$();

    static {
        OPALLogger$.MODULE$.updateLogger(GlobalLogContext$.MODULE$, new ConsoleOPALLogger(true, Error$.MODULE$));
    }

    private final String Usage() {
        return "Usage: java \u2026Disassembler \n       [-help will print this help and terminate.]\n       [-o <File> the name of the file to which the generated html page should be written]\n       [-open the generated html page will be opened in a browser]\n       [-source <File> a class or jar file or a directory containing jar or class files;\n                       if no source files/folders are specified the current folder will be\n                       searched for class files]*\n       [-sourceJDK the current JDK/JRE is added as a source folder]\n       [-noDefaultCSS the generated html page will have no CSS styling]\n       [-noMethodsFilter the generated html page will have no embedded means to filter methods\n                         (as a whole, the file will not contain any JavaScript code)]\n       [-noHeader the generated output will have no header; \n                  the top level element will be <div class=\"class_file\">...</div>\n                  (automatically activates \"-noMethodsFilter\" and \"-noDefaultCSS\")]\n       [-css <Source> the path (URL) of a CSS file (\".csss\")\n                      which will be referenced from the generated HTML page]\n       [-js <Source> the path (URL) of a JavaScript file (\".js\")\n                     which will be referenced from the generated HTML page]\n       [-showProgress shows the progress when searching for the class file]\n       [<ClassName> name of the class for which we want to create the HTML page;\n                    if not specified the first class that is found on the given path is taken;\n                    this is particularly useful if the source identifies a particular \".class\" file]\n\nNote:   \n       If no parameters are specified, the first class file found in the current folder\n       or any subfolder of it will be disassembled.\nExample:\n       java \u2026Disassembler -source /Library/jre/lib/rt.jar java.util.ArrayList";
    }

    public Nothing$ handleError(String error, boolean showUsage) {
        block0: {
            Console$.MODULE$.err().println(new StringBuilder(7).append("Error: ").append(error).toString());
            if (!showUsage) break block0;
            Console$.MODULE$.out().println("Usage: java \u2026Disassembler \n       [-help will print this help and terminate.]\n       [-o <File> the name of the file to which the generated html page should be written]\n       [-open the generated html page will be opened in a browser]\n       [-source <File> a class or jar file or a directory containing jar or class files;\n                       if no source files/folders are specified the current folder will be\n                       searched for class files]*\n       [-sourceJDK the current JDK/JRE is added as a source folder]\n       [-noDefaultCSS the generated html page will have no CSS styling]\n       [-noMethodsFilter the generated html page will have no embedded means to filter methods\n                         (as a whole, the file will not contain any JavaScript code)]\n       [-noHeader the generated output will have no header; \n                  the top level element will be <div class=\"class_file\">...</div>\n                  (automatically activates \"-noMethodsFilter\" and \"-noDefaultCSS\")]\n       [-css <Source> the path (URL) of a CSS file (\".csss\")\n                      which will be referenced from the generated HTML page]\n       [-js <Source> the path (URL) of a JavaScript file (\".js\")\n                     which will be referenced from the generated HTML page]\n       [-showProgress shows the progress when searching for the class file]\n       [<ClassName> name of the class for which we want to create the HTML page;\n                    if not specified the first class that is found on the given path is taken;\n                    this is particularly useful if the source identifies a particular \".class\" file]\n\nNote:   \n       If no parameters are specified, the first class file found in the current folder\n       or any subfolder of it will be disassembled.\nExample:\n       java \u2026Disassembler -source /Library/jre/lib/rt.jar java.util.ArrayList");
        }
        return scala.sys.package$.MODULE$.exit(1);
    }

    public boolean handleError$default$2() {
        return true;
    }

    public void main(String[] args) {
        Option htmlCSS;
        Option option;
        Function1<ClassFile, Object> & Serializable classFileFilter;
        Object sourceFiles;
        Either<Tuple2<Object, URL>, Set<String>> either;
        boolean toStdOut = true;
        Option toFile = None$.MODULE$;
        boolean openHTMLFile = false;
        List sources = scala.package$.MODULE$.List().empty();
        boolean noDefaultCSS = false;
        boolean noHeader = false;
        boolean noMethodsFilter = false;
        Option css = None$.MODULE$;
        Option js = None$.MODULE$;
        boolean showProgress = false;
        ObjectRef<Object> className = ObjectRef.create(null);
        IntRef i = IntRef.create(0);
        while (i.elem < args.length) {
            block37: {
                String string;
                block36: {
                    string = args[i.elem];
                    switch (string == null ? 0 : string.hashCode()) {
                        case -1951605047: {
                            if (!"-sourceJDK".equals(string)) break block36;
                            sources = sources.$colon$colon(org.opalj.bytecode.package$.MODULE$.JRELibraryFolder().toString());
                            break block37;
                        }
                        case -863487556: {
                            if (!"-noMethodsFilter".equals(string)) break block36;
                            noMethodsFilter = true;
                            break block37;
                        }
                        case 1506: {
                            if (!"-o".equals(string)) break block36;
                            toFile = new Some<String>(this.readNextArg$1(i, args));
                            toStdOut = false;
                            break block37;
                        }
                        case 46646: {
                            if (!"-js".equals(string)) break block36;
                            js = new Some<String>(this.readNextArg$1(i, args));
                            break block37;
                        }
                        case 1439414: {
                            if (!"-css".equals(string)) break block36;
                            css = new Some<String>(this.readNextArg$1(i, args));
                            break block37;
                        }
                        case 44757230: {
                            if ("-help".equals(string)) {
                                break;
                            }
                            break block36;
                        }
                        case 44976119: {
                            if (!"-open".equals(string)) break block36;
                            openHTMLFile = true;
                            toStdOut = false;
                            break block37;
                        }
                        case 386454152: {
                            if (!"-source".equals(string)) break block36;
                            sources = sources.$colon$colon(this.readNextArg$1(i, args));
                            break block37;
                        }
                        case 590760667: {
                            if (!"-noHeader".equals(string)) break block36;
                            noHeader = true;
                            noMethodsFilter = true;
                            noDefaultCSS = true;
                            break block37;
                        }
                        case 1333069025: {
                            if ("--help".equals(string)) {
                                break;
                            }
                            break block36;
                        }
                        case 1774947664: {
                            if (!"-noDefaultCSS".equals(string)) break block36;
                            noDefaultCSS = true;
                            break block37;
                        }
                        case 2123684087: {
                            if (!"-showProgress".equals(string)) break block36;
                            showProgress = true;
                            break block37;
                        }
                        default: {
                            break block36;
                        }
                    }
                    Console$.MODULE$.out().println("Usage: java \u2026Disassembler \n       [-help will print this help and terminate.]\n       [-o <File> the name of the file to which the generated html page should be written]\n       [-open the generated html page will be opened in a browser]\n       [-source <File> a class or jar file or a directory containing jar or class files;\n                       if no source files/folders are specified the current folder will be\n                       searched for class files]*\n       [-sourceJDK the current JDK/JRE is added as a source folder]\n       [-noDefaultCSS the generated html page will have no CSS styling]\n       [-noMethodsFilter the generated html page will have no embedded means to filter methods\n                         (as a whole, the file will not contain any JavaScript code)]\n       [-noHeader the generated output will have no header; \n                  the top level element will be <div class=\"class_file\">...</div>\n                  (automatically activates \"-noMethodsFilter\" and \"-noDefaultCSS\")]\n       [-css <Source> the path (URL) of a CSS file (\".csss\")\n                      which will be referenced from the generated HTML page]\n       [-js <Source> the path (URL) of a JavaScript file (\".js\")\n                     which will be referenced from the generated HTML page]\n       [-showProgress shows the progress when searching for the class file]\n       [<ClassName> name of the class for which we want to create the HTML page;\n                    if not specified the first class that is found on the given path is taken;\n                    this is particularly useful if the source identifies a particular \".class\" file]\n\nNote:   \n       If no parameters are specified, the first class file found in the current folder\n       or any subfolder of it will be disassembled.\nExample:\n       java \u2026Disassembler -source /Library/jre/lib/rt.jar java.util.ArrayList");
                    return;
                }
                className.elem = string.replace('/', '.');
            }
            ++i.elem;
        }
        if (noHeader) {
            if (css.nonEmpty()) {
                throw this.handleError("specifying -noHeader and a css file is not supported", this.handleError$default$2());
            }
            if (js.nonEmpty()) {
                throw this.handleError("specifying -noHeader and a js file is not supported", this.handleError$default$2());
            }
        }
        if (sources.isEmpty()) {
            sources = new $colon$colon<Nothing$>((Nothing$)((Object)System.getProperty("user.dir")), Nil$.MODULE$);
        }
        if (!((either = ClassFileReader$.MODULE$.findClassFile((Iterable<File>)(sourceFiles = sources.map((Function1<String, File> & Serializable)src -> {
            File f = new File((String)src);
            if (!f.exists()) {
                throw MODULE$.handleError(new StringBuilder(21).append("file does not exist: ").append((String)src).toString(), false);
            }
            if (!f.canRead()) {
                throw MODULE$.handleError(new StringBuilder(13).append("cannot read: ").append((String)src).toString(), false);
            }
            return f;
        })), (Function1<File, BoxedUnit>)(showProgress ? (Function1<File, Object> & Serializable)x -> {
            Predef$.MODULE$.println(x);
            return BoxedUnit.UNIT;
        } : (Function1<File, Object> & Serializable)f -> {
            Disassembler$.$anonfun$main$5(f);
            return BoxedUnit.UNIT;
        }), (Function1<Object, Object>)(classFileFilter = (String)className.elem == null ? (Function1<ClassFile, Object> & Serializable)cf -> BoxesRunTime.boxToBoolean(Disassembler$.$anonfun$main$2(cf)) : (Function1<ClassFile, Object> & Serializable)cf -> BoxesRunTime.boxToBoolean(Disassembler$.$anonfun$main$3(className, cf))), (Function1<Object, String>)(Function1<ClassFile, String> & Serializable)cf -> cf.thisType().asJava(), ClassFileReader$.MODULE$.findClassFile$default$5())) instanceof Left)) {
            if (either instanceof Right) {
                Right right = (Right)either;
                Set altClassNames = (Set)right.value();
                if (altClassNames.isEmpty()) {
                    throw this.handleError(sources.mkString("cannot find class files in: ", ", ", ""), this.handleError$default$2());
                }
                List allClassNames = ((IterableOnceOps)altClassNames.map((Function1<String, Tuple2> & Serializable)cf -> new Tuple2<Integer, String>(BoxesRunTime.boxToInteger(LevenshteinDistance.getDefaultInstance().apply((String)className$1.elem, (CharSequence)cf)), (String)cf))).toList();
                Object mostRelated = ((List)((List)allClassNames.sortWith((Function2<Tuple2, Tuple2, Object> & Serializable)(l, r) -> BoxesRunTime.boxToBoolean(Disassembler$.$anonfun$main$8(l, r)))).map((Function1<Tuple2, String> & Serializable)x$1 -> (String)x$1._2())).take(15);
                String ending = ((List)mostRelated).length() > 15 ? ", ...)" : ")";
                String messageHeader = new StringBuilder(12).append("can't find: ").append((String)className.elem).toString();
                String message = ((AbstractIterable)mostRelated).mkString(new StringBuilder(11).append(messageHeader).append(" (similar: ").toString(), ", ", ending);
                throw this.handleError(message, false);
            }
            throw new MatchError(either);
        }
        Left left = (Left)either;
        Tuple2 cfSource = (Tuple2)left.value();
        Tuple2 tuple2 = cfSource;
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        ClassFile classFile = (ClassFile)tuple2._1();
        URL source = (URL)tuple2._2();
        Tuple2<ClassFile, URL> tuple22 = new Tuple2<ClassFile, URL>(classFile, source);
        ClassFile classFile2 = tuple22._1();
        URL source2 = tuple22._2();
        String classNameAsFileName = package$.MODULE$.sanitizeFileName(classFile2.thisType().asJava());
        if (openHTMLFile) {
            if (toFile.isEmpty()) {
                option = new Some<File>(File.createTempFile(classNameAsFileName, ".html"));
            } else {
                File f2 = new File((String)toFile.get());
                if (f2.exists() && !f2.canWrite()) {
                    throw this.handleError(new StringBuilder(15).append("cannot update: ").append(f2).toString(), this.handleError$default$2());
                }
                option = new Some<File>(f2);
            }
        } else if (toFile.isDefined()) {
            File f3 = new File((String)toFile.get());
            if (f3.exists() && !f3.canWrite()) {
                throw this.handleError(new StringBuilder(15).append("cannot update: ").append(f3).toString(), this.handleError$default$2());
            }
            option = new Some<File>(f3);
        } else {
            option = None$.MODULE$;
        }
        Option targetFile = option;
        Option option2 = htmlCSS = noDefaultCSS ? None$.MODULE$ : new Some<String>(ClassFile$.MODULE$.TheCSS());
        String xHTML = noHeader ? classFile2.classFileToXHTML(new Some<Object>(source2)).toString() : classFile2.toXHTML(new Some<Object>(source2), htmlCSS, css, js, !noMethodsFilter).toString();
        Option option3 = targetFile;
        if (option3 instanceof Some) {
            Some some = (Some)option3;
            File f4 = (File)some.value();
            Files.write(f4.toPath(), xHTML.toString().getBytes("UTF-8"), new OpenOption[0]);
            Predef$.MODULE$.println(new StringBuilder(7).append("wrote: ").append(f4).toString());
            if (openHTMLFile) {
                package$.MODULE$.open(f4);
                return;
            }
            return;
        }
        if (None$.MODULE$.equals(option3)) {
            Console$.MODULE$.out().println(xHTML);
            return;
        }
        throw new MatchError(option3);
    }

    private final String readNextArg$1(IntRef i$1, String[] args$1) {
        ++i$1.elem;
        if (i$1.elem < args$1.length) {
            return args$1[i$1.elem];
        }
        throw this.handleError(Predef$.MODULE$.wrapRefArray((Object[])args$1).mkString("missing argument: ", " ", ""), this.handleError$default$2());
    }

    public static final /* synthetic */ boolean $anonfun$main$2(ClassFile cf) {
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$main$3(ObjectRef className$1, ClassFile cf) {
        String string = cf.thisType().asJava();
        String string2 = (String)className$1.elem;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ void $anonfun$main$5(File f) {
    }

    public static final /* synthetic */ boolean $anonfun$main$8(Tuple2 l, Tuple2 r) {
        return l._1$mcI$sp() < r._1$mcI$sp();
    }

    private Disassembler$() {
    }
}

