/*
 * Decompiled with CFR 0.152.
 */
package org.opalj.concurrent;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.opalj.concurrent.ConcurrentExceptions;
import org.opalj.concurrent.OPALBoundedThreadPoolExecutor;
import org.opalj.log.GlobalLogContext$;
import org.opalj.log.OPALLogger$;
import scala.Console$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.StringOps$;
import scala.collection.immutable.ArraySeq$;
import scala.collection.immutable.IndexedSeq;
import scala.collection.parallel.ExecutionContextTaskSupport;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContext$;
import scala.runtime.BoxedUnit;
import scala.runtime.ObjectRef;
import scala.runtime.RichLong$;
import scala.util.control.ControlThrowable;

public final class package$ {
    public static final package$ MODULE$;
    private static final Function0<Object> defaultIsInterrupted;
    private static final ExecutorService OPALUnboundedThreadPool;
    private static final ExecutionContext OPALUnboundedExecutionContext;
    private static final int NumberOfThreadsForCPUBoundTasks;
    private static final int NumberOfThreadsForIOBoundTasks;
    private static final Thread.UncaughtExceptionHandler UncaughtExceptionHandler;
    private static final OPALBoundedThreadPoolExecutor OPALHTBoundedThreadPool;
    private static final ExecutionContext OPALHTBoundedExecutionContext;
    private static final ExecutionContextTaskSupport OPALHTBoundedExecutionContextTaskSupport;

    static {
        int n;
        int n2;
        MODULE$ = new package$();
        defaultIsInterrupted = () -> Thread.currentThread().isInterrupted();
        AtomicLong nextID = new AtomicLong(0L);
        OPALUnboundedThreadPool = Executors.newCachedThreadPool(new ThreadFactory(nextID){
            private final AtomicLong nextID$1;

            public Thread newThread(Runnable r) {
                String name = new StringBuilder(35).append("[global] opalj.ThreadPool - Thread ").append(this.nextID$1.incrementAndGet()).toString();
                Thread t = new Thread(r, name);
                t.setDaemon(true);
                t.setUncaughtExceptionHandler(package$.MODULE$.UncaughtExceptionHandler());
                return t;
            }
            {
                this.nextID$1 = nextID$1;
            }
        });
        OPALUnboundedExecutionContext = ExecutionContext$.MODULE$.fromExecutorService(MODULE$.OPALUnboundedThreadPool());
        String maxCPUBoundTasks = System.getProperty("org.opalj.threads.CPUBoundTasks");
        if (maxCPUBoundTasks != null) {
            int t = Integer.parseInt(maxCPUBoundTasks);
            if (t <= 0) {
                String message = new StringBuilder(65).append("org.opalj.threads.CPUBoundTasks must be larger than 0 (current: ").append(t).append(")").toString();
                throw new IllegalArgumentException(message);
            }
            n2 = t;
        } else {
            OPALLogger$.MODULE$.warn("OPAL", "the property org.opalj.threads.CPUBoundTasks is unspecified", MODULE$.logContext());
            n2 = Runtime.getRuntime().availableProcessors();
        }
        NumberOfThreadsForCPUBoundTasks = n2;
        OPALLogger$.MODULE$.info("OPAL", new StringBuilder(198).append("using ").append(MODULE$.NumberOfThreadsForCPUBoundTasks()).append(" thread(s) for CPU bound tasks ").append("(can be changed by setting the system property org.opalj.threads.CPUBoundTasks; ").append("the number should be equal to the number of physical \u2013 not hyperthreaded \u2013 cores)").toString(), MODULE$.logContext());
        String maxIOBoundTasks = System.getProperty("org.opalj.threads.IOBoundTasks");
        if (maxIOBoundTasks != null) {
            int s = Integer.parseInt(maxIOBoundTasks);
            if (s < MODULE$.NumberOfThreadsForCPUBoundTasks()) {
                throw new IllegalArgumentException(new StringBuilder(88).append("org.opalj.threads.IOBoundTasks===").append(s).append(" must be larger than ").append("org.opalj.threads.CPUBoundTasks===").append(MODULE$.NumberOfThreadsForCPUBoundTasks()).toString());
            }
            n = s;
        } else {
            OPALLogger$.MODULE$.warn("OPAL", "the property org.opalj.threads.IOBoundTasks is unspecified", MODULE$.logContext());
            n = Runtime.getRuntime().availableProcessors() * 2;
        }
        NumberOfThreadsForIOBoundTasks = n;
        OPALLogger$.MODULE$.info("OPAL", new StringBuilder(203).append("using at most ").append(MODULE$.NumberOfThreadsForIOBoundTasks()).append(" thread(s) for IO bound tasks ").append("(can be changed by setting the system property org.opalj.threads.IOBoundTasks; ").append("the number should be betweeen 1 and 2 times the number of (hyperthreaded) cores)").toString(), MODULE$.logContext());
        UncaughtExceptionHandler = new Thread.UncaughtExceptionHandler(){

            public void uncaughtException(Thread t, Throwable e) {
                try {
                    package$.MODULE$.handleUncaughtException(e);
                }
                catch (Throwable t2) {
                    Console$.MODULE$.err().println("[fatal] internal error when reporting errors: ");
                    t2.printStackTrace(Console$.MODULE$.err());
                }
            }
        };
        OPALHTBoundedThreadPool = MODULE$.BoundedThreadPool("global", MODULE$.NumberOfThreadsForIOBoundTasks());
        OPALHTBoundedExecutionContext = ExecutionContext$.MODULE$.fromExecutorService(MODULE$.OPALHTBoundedThreadPool());
        OPALHTBoundedExecutionContextTaskSupport = new ExecutionContextTaskSupport(){

            public int parallelismLevel() {
                return package$.MODULE$.NumberOfThreadsForCPUBoundTasks();
            }
        };
    }

    private GlobalLogContext$ logContext() {
        return GlobalLogContext$.MODULE$;
    }

    public final Function0<Object> defaultIsInterrupted() {
        return defaultIsInterrupted;
    }

    public final void handleUncaughtException(Throwable t) {
        OPALLogger$.MODULE$.error("internal", "uncaught exception", t, this.logContext());
    }

    public final void handleUncaughtException(Thread t, Throwable e) {
        OPALLogger$.MODULE$.error("internal", new StringBuilder(28).append("uncaught exception (Thread=").append(t.getName()).append(")").toString(), e, this.logContext());
    }

    public final ExecutorService OPALUnboundedThreadPool() {
        return OPALUnboundedThreadPool;
    }

    public final ExecutionContext OPALUnboundedExecutionContext() {
        return OPALUnboundedExecutionContext;
    }

    public final int NumberOfThreadsForCPUBoundTasks() {
        return NumberOfThreadsForCPUBoundTasks;
    }

    public final int NumberOfThreadsForIOBoundTasks() {
        return NumberOfThreadsForIOBoundTasks;
    }

    public final Thread.UncaughtExceptionHandler UncaughtExceptionHandler() {
        return UncaughtExceptionHandler;
    }

    public OPALBoundedThreadPoolExecutor BoundedThreadPool(String name, int n) {
        String groupName = new StringBuilder(24).append("[").append(name).append("/").append(StringOps$.MODULE$.drop$extension(Predef$.MODULE$.augmentString(RichLong$.MODULE$.toHexString$extension(Predef$.MODULE$.longWrapper(System.nanoTime()))), 4)).append("] opalj.ThreadPool[N=").append(n).append("]").toString();
        ThreadGroup group = new ThreadGroup(groupName);
        OPALBoundedThreadPoolExecutor tp = new OPALBoundedThreadPoolExecutor(n, group);
        tp.allowCoreThreadTimeOut(true);
        tp.prestartAllCoreThreads();
        return tp;
    }

    public ExecutionContext BoundedExecutionContext(String name, int n) {
        return ExecutionContext$.MODULE$.fromExecutorService(this.BoundedThreadPool(name, n));
    }

    public final OPALBoundedThreadPoolExecutor OPALHTBoundedThreadPool() {
        return OPALHTBoundedThreadPool;
    }

    public final ExecutionContext OPALHTBoundedExecutionContext() {
        return OPALHTBoundedExecutionContext;
    }

    public final ExecutionContextTaskSupport OPALHTBoundedExecutionContextTaskSupport() {
        return OPALHTBoundedExecutionContextTaskSupport;
    }

    public final <T, U> void parForeachArrayElement(Object data, int parallelizationLevel, Function0<Object> isInterrupted, Function1<T, U> f) throws ConcurrentExceptions {
        this.parForeachSeqElement(ArraySeq$.MODULE$.unsafeWrapArray(data), parallelizationLevel, isInterrupted, f);
    }

    public final <T, U> int parForeachArrayElement$default$2() {
        return this.NumberOfThreadsForCPUBoundTasks();
    }

    public final <T, U> Function0<Object> parForeachArrayElement$default$3() {
        return this.defaultIsInterrupted();
    }

    public final <T, U> void parForeachSeqElement(IndexedSeq<T> data, int parallelizationLevel, Function0<Object> isInterrupted, Function1<T, U> f) throws ConcurrentExceptions {
        int dataLength = data.length();
        if (dataLength == 0) {
            return;
        }
        AtomicInteger index = new AtomicInteger(0);
        ObjectRef<Object> exceptions = ObjectRef.create(null);
        if (parallelizationLevel == 1 || dataLength == 1) {
            package$.analyzeArrayElements$1(index, dataLength, isInterrupted, f, data, exceptions);
        } else {
            int maxThreads = Math.min(parallelizationLevel, dataLength);
            CountDownLatch latch = new CountDownLatch(maxThreads);
            ExecutorService pool = this.OPALUnboundedThreadPool();
            try {
                for (int t = 0; t < maxThreads; ++t) {
                    pool.execute(() -> {
                        try {
                            package$.analyzeArrayElements$1(index, dataLength, isInterrupted, f, data, exceptions);
                        }
                        finally {
                            latch.countDown();
                        }
                    });
                }
                latch.await();
            }
            catch (Throwable t) {
                package$.addSuppressed$1(t, index, exceptions);
            }
        }
        if ((ConcurrentExceptions)exceptions.elem != null) {
            throw (ConcurrentExceptions)exceptions.elem;
        }
    }

    public final <T, U> int parForeachSeqElement$default$2() {
        return this.NumberOfThreadsForCPUBoundTasks();
    }

    public final <T, U> Function0<Object> parForeachSeqElement$default$3() {
        return this.defaultIsInterrupted();
    }

    private static final void addSuppressed$1(Throwable throwable, AtomicInteger index$1, ObjectRef exceptions$1) {
        AtomicInteger atomicInteger = index$1;
        synchronized (atomicInteger) {
            if ((ConcurrentExceptions)exceptions$1.elem == null) {
                exceptions$1.elem = new ConcurrentExceptions();
            }
            ((ConcurrentExceptions)exceptions$1.elem).addSuppressed(throwable);
        }
    }

    private static final void analyzeArrayElements$1(AtomicInteger index$1, int dataLength$1, Function0 isInterrupted$1, Function1 f$1, IndexedSeq data$1, ObjectRef exceptions$1) {
        int i = -1;
        while ((i = index$1.getAndIncrement()) < dataLength$1 && !isInterrupted$1.apply$mcZ$sp()) {
            Object object;
            try {
                object = f$1.apply(data$1.apply(i));
            }
            catch (ControlThrowable ct) {
                Throwable t = new Throwable("unsupported non-local return", ct);
                package$.addSuppressed$1(t, index$1, exceptions$1);
                object = BoxedUnit.UNIT;
            }
            catch (Throwable t) {
                package$.addSuppressed$1(t, index$1, exceptions$1);
                object = BoxedUnit.UNIT;
            }
        }
    }

    private package$() {
    }
}

