/*
 * Decompiled with CFR 0.152.
 */
package org.opalj.concurrent;

import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.opalj.concurrent.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\u00193AAB\u0004\u0001\u001d!A\u0001\u0004\u0001B\u0001B\u0003%\u0011\u0004\u0003\u0005 \u0001\t\u0015\r\u0011\"\u0001!\u0011!9\u0003A!A!\u0002\u0013\t\u0003\"\u0002\u0015\u0001\t\u0003I\u0003\"\u0002\u0018\u0001\t\u0003z#!H(Q\u00032\u0013u.\u001e8eK\u0012$\u0006N]3bIB{w\u000e\\#yK\u000e,Ho\u001c:\u000b\u0005!I\u0011AC2p]\u000e,(O]3oi*\u0011!bC\u0001\u0006_B\fGN\u001b\u0006\u0002\u0019\u0005\u0019qN]4\u0004\u0001M\u0011\u0001a\u0004\t\u0003!Yi\u0011!\u0005\u0006\u0003\u0011IQ!a\u0005\u000b\u0002\tU$\u0018\u000e\u001c\u0006\u0002+\u0005!!.\u0019<b\u0013\t9\u0012C\u0001\nUQJ,\u0017\r\u001a)p_2,\u00050Z2vi>\u0014\u0018!\u00018\u0011\u0005iiR\"A\u000e\u000b\u0003q\tQa]2bY\u0006L!AH\u000e\u0003\u0007%sG/A\u0003he>,\b/F\u0001\"!\t\u0011S%D\u0001$\u0015\t!C#\u0001\u0003mC:<\u0017B\u0001\u0014$\u0005-!\u0006N]3bI\u001e\u0013x.\u001e9\u0002\r\u001d\u0014x.\u001e9!\u0003\u0019a\u0014N\\5u}Q\u0019!\u0006L\u0017\u0011\u0005-\u0002Q\"A\u0004\t\u000ba!\u0001\u0019A\r\t\u000b}!\u0001\u0019A\u0011\u0002\u0019\u00054G/\u001a:Fq\u0016\u001cW\u000f^3\u0015\u0007A\u001a\u0004\b\u0005\u0002\u001bc%\u0011!g\u0007\u0002\u0005+:LG\u000fC\u00035\u000b\u0001\u0007Q'A\u0001s!\t\u0011c'\u0003\u00028G\tA!+\u001e8oC\ndW\rC\u0003:\u000b\u0001\u0007!(A\u0001u!\tY4I\u0004\u0002=\u0003:\u0011Q\bQ\u0007\u0002})\u0011q(D\u0001\u0007yI|w\u000e\u001e \n\u0003qI!AQ\u000e\u0002\u000fA\f7m[1hK&\u0011A)\u0012\u0002\n)\"\u0014xn^1cY\u0016T!AQ\u000e")
public class OPALBoundedThreadPoolExecutor
extends ThreadPoolExecutor {
    private final ThreadGroup group;

    public ThreadGroup group() {
        return this.group;
    }

    @Override
    public void afterExecute(Runnable r, Throwable t) {
        BoxedUnit boxedUnit;
        super.afterExecute(r, t);
        Throwable e = t;
        if (e == null && r instanceof Future) {
            try {
                boxedUnit = ((Future)((Object)r)).get();
            }
            catch (CancellationException ce) {
                e = ce;
                boxedUnit = BoxedUnit.UNIT;
            }
            catch (ExecutionException ee) {
                e = ee.getCause();
                boxedUnit = BoxedUnit.UNIT;
            }
            catch (InterruptedException ie) {
                e = ie;
                Thread.currentThread().interrupt();
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        if (e != null) {
            package$.MODULE$.handleUncaughtException(e);
            return;
        }
    }

    public OPALBoundedThreadPoolExecutor(int n, ThreadGroup group) {
        this.group = group;
        super(n, n, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadFactory(group){
            private final AtomicLong nextID;
            private final ThreadGroup group$1;

            public AtomicLong nextID() {
                return this.nextID;
            }

            public Thread newThread(Runnable r) {
                String id = String.valueOf(BoxesRunTime.boxToLong(this.nextID().incrementAndGet()));
                String name = new StringBuilder(10).append(this.group$1.getName()).append(" - Thread ").append(id).toString();
                Thread t = new Thread(this.group$1, r, name);
                t.setDaemon(true);
                t.setUncaughtExceptionHandler(package$.MODULE$.UncaughtExceptionHandler());
                return t;
            }
            {
                this.group$1 = group$1;
                this.nextID = new AtomicLong(0L);
            }
        });
    }
}

