/*
 * Decompiled with CFR 0.152.
 */
package org.opalj.collection.immutable;

import java.util.Arrays;
import org.opalj.collection.IntIterator;
import org.opalj.collection.immutable.BitArraySet;
import org.opalj.collection.immutable.BitArraySet0$;
import org.opalj.collection.immutable.BitArraySet32;
import org.opalj.collection.immutable.BitArraySet64;
import scala.Array$;
import scala.MatchError;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u000553Q\u0001D\u0007\u0003\u001bUA\u0001B\u0007\u0001\u0003\u0006\u0004%\t\u0001\b\u0005\tM\u0001\u0011\t\u0011)A\u0005;!)q\u0005\u0001C\u0001Q!)1\u0006\u0001C!Y!)\u0001\u0007\u0001C!c!)A\u0007\u0001C!k!)q\u0007\u0001C!q!)1\b\u0001C!y!)a\b\u0001C!\u007f!)A\t\u0001C!\u000b\")1\n\u0001C!\u0019\na!)\u001b;BeJ\f\u0017pU3u\u001d*\u0011abD\u0001\nS6lW\u000f^1cY\u0016T!\u0001E\t\u0002\u0015\r|G\u000e\\3di&|gN\u0003\u0002\u0013'\u0005)q\u000e]1mU*\tA#A\u0002pe\u001e\u001c\"\u0001\u0001\f\u0011\u0005]AR\"A\u0007\n\u0005ei!a\u0003\"ji\u0006\u0013(/Y=TKR\f1a]3u\u0007\u0001)\u0012!\b\t\u0004=\u0005\u001aS\"A\u0010\u000b\u0003\u0001\nQa]2bY\u0006L!AI\u0010\u0003\u000b\u0005\u0013(/Y=\u0011\u0005y!\u0013BA\u0013 \u0005\rIe\u000e^\u0001\u0005g\u0016$\b%\u0001\u0004=S:LGO\u0010\u000b\u0003S)\u0002\"a\u0006\u0001\t\u000bi\u0019\u0001\u0019A\u000f\u0002\u000f%\u001cX)\u001c9usV\tQ\u0006\u0005\u0002\u001f]%\u0011qf\b\u0002\b\u0005>|G.Z1o\u0003\u0015!\u0003\u000f\\;t)\t1\"\u0007C\u00034\u000b\u0001\u00071%A\u0001j\u0003\u0019!S.\u001b8vgR\u0011aC\u000e\u0005\u0006g\u0019\u0001\raI\u0001\u000bIAdWo\u001d\u0013qYV\u001cHC\u0001\f:\u0011\u0015Qt\u00011\u0001\u0017\u0003\u0011!\b.\u0019;\u0002\u0011\r|g\u000e^1j]N$\"!L\u001f\t\u000bMB\u0001\u0019A\u0012\u0002\u0011%$XM]1u_J,\u0012\u0001\u0011\t\u0003\u0003\nk\u0011aD\u0005\u0003\u0007>\u00111\"\u00138u\u0013R,'/\u0019;pe\u00061Q-];bYN$\"!\f$\t\u000b\u001dS\u0001\u0019\u0001%\u0002\u000b=$\b.\u001a:\u0011\u0005yI\u0015B\u0001& \u0005\r\te._\u0001\tQ\u0006\u001c\bnQ8eKV\t1\u0005")
public final class BitArraySetN
extends BitArraySet {
    private final int[] set;

    public int[] set() {
        return this.set;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public BitArraySet $plus(int i) {
        int newBucketValue;
        int bucket = i / 32;
        int setLength = this.set().length;
        if (bucket >= setLength) {
            int[] newSet = new int[bucket + 1];
            Array$.MODULE$.copy(this.set(), 0, newSet, 0, setLength);
            newSet[bucket] = 1 << i - 32 * bucket;
            return new BitArraySetN(newSet);
        }
        int oldBucketValue = this.set()[bucket];
        if (oldBucketValue == (newBucketValue = oldBucketValue | 1 << i - 32 * bucket)) {
            return this;
        }
        int[] newSet = new int[setLength];
        Array$.MODULE$.copy(this.set(), 0, newSet, 0, setLength);
        newSet[bucket] = newBucketValue;
        return new BitArraySetN(newSet);
    }

    @Override
    public BitArraySet $minus(int i) {
        int bucket = i / 32;
        int setLength = this.set().length;
        if (bucket >= setLength) {
            return this;
        }
        int oldBucketValue = this.set()[bucket];
        int newBucketValue = oldBucketValue & (0xFFFFFFFF & ~(1 << i - 32 * bucket));
        if (newBucketValue == oldBucketValue) {
            return this;
        }
        int lastBucket = setLength - 1;
        if (newBucketValue == 0 && bucket == lastBucket) {
            int emptyBuckets;
            for (emptyBuckets = 1; emptyBuckets < setLength && this.set()[lastBucket - emptyBuckets] == 0; ++emptyBuckets) {
            }
            int n = setLength - emptyBuckets;
            switch (n) {
                case 0: {
                    return BitArraySet0$.MODULE$;
                }
                case 1: {
                    return new BitArraySet32(this.set()[0]);
                }
                case 2: {
                    long newSet = Integer.toUnsignedLong(this.set()[0]) | Integer.toUnsignedLong(this.set()[1]) << 32;
                    return new BitArraySet64(newSet);
                }
            }
            int[] newSet = new int[n];
            Array$.MODULE$.copy(this.set(), 0, newSet, 0, n);
            return new BitArraySetN(newSet);
        }
        int[] newSet = new int[setLength];
        Array$.MODULE$.copy(this.set(), 0, newSet, 0, setLength);
        newSet[bucket] = newBucketValue;
        return new BitArraySetN(newSet);
    }

    @Override
    public BitArraySet $plus$plus(BitArraySet that) {
        BitArraySet bitArraySet = that;
        if (((Object)BitArraySet0$.MODULE$).equals(bitArraySet)) {
            return this;
        }
        if (bitArraySet instanceof BitArraySet32) {
            BitArraySet32 bitArraySet32 = (BitArraySet32)bitArraySet;
            int thisSet0 = this.set()[0];
            int newSet0 = thisSet0 | bitArraySet32.set();
            if (newSet0 == thisSet0) {
                return this;
            }
            int[] newSet = (int[])this.set().clone();
            newSet[0] = newSet0;
            return new BitArraySetN(newSet);
        }
        if (bitArraySet instanceof BitArraySet64) {
            BitArraySet64 bitArraySet64 = (BitArraySet64)bitArraySet;
            long thisSet = Integer.toUnsignedLong(this.set()[0]) | Integer.toUnsignedLong(this.set()[1]) << 32;
            long newSet64 = thisSet | bitArraySet64.set();
            if (newSet64 == thisSet) {
                return this;
            }
            int[] newSet = (int[])this.set().clone();
            newSet[0] = (int)newSet64;
            newSet[1] = (int)(newSet64 >>> 32);
            return new BitArraySetN(newSet);
        }
        if (bitArraySet instanceof BitArraySetN) {
            int i;
            int thatSetLength;
            BitArraySetN bitArraySetN = (BitArraySetN)bitArraySet;
            int[] thisSet = this.set();
            int[] thatSet = bitArraySetN.set();
            int thisSetLength = this.set().length;
            if (thisSetLength == (thatSetLength = bitArraySetN.set().length)) {
                boolean takeThis = true;
                boolean takeThat = true;
                int[] newSet = new int[thisSetLength];
                for (int i2 = 0; i2 < thisSetLength; ++i2) {
                    int thisSetI = thisSet[i2];
                    int thatSetI = thatSet[i2];
                    int newSetI = thisSetI | thatSetI;
                    takeThis &= newSetI == thisSetI;
                    takeThat &= newSetI == thatSetI;
                    newSet[i2] = newSetI;
                }
                if (takeThis) {
                    return this;
                }
                if (takeThat) {
                    return bitArraySetN;
                }
                return new BitArraySetN(newSet);
            }
            if (thisSetLength > thatSetLength) {
                int i3;
                boolean takeThis = true;
                int[] newSet = new int[thisSetLength];
                for (i3 = 0; i3 < thatSetLength; ++i3) {
                    int thisSetI = thisSet[i3];
                    int thatSetI = thatSet[i3];
                    int newSetI = thisSetI | thatSetI;
                    takeThis &= newSetI == thisSetI;
                    newSet[i3] = newSetI;
                }
                if (takeThis) {
                    return this;
                }
                Array$.MODULE$.copy(this.set(), i3, newSet, i3, thisSetLength - i3);
                return new BitArraySetN(newSet);
            }
            boolean takeThat = true;
            int[] newSet = new int[thatSetLength];
            for (i = 0; i < thisSetLength; ++i) {
                int thisSetI = thisSet[i];
                int thatSetI = thatSet[i];
                int newSetI = thisSetI | thatSetI;
                takeThat &= newSetI == thatSetI;
                newSet[i] = newSetI;
            }
            if (takeThat) {
                return bitArraySetN;
            }
            Array$.MODULE$.copy(bitArraySetN.set(), i, newSet, i, thatSetLength - i);
            return new BitArraySetN(newSet);
        }
        throw new MatchError(bitArraySet);
    }

    @Override
    public boolean contains(int i) {
        int bucket = i / 32;
        int[] set = this.set();
        if (bucket >= set.length) {
            return false;
        }
        return (set[bucket] & 1 << i - 32 * bucket) != 0;
    }

    @Override
    public IntIterator iterator() {
        return new IntIterator(this){
            private final int max;
            private int i;
            private final /* synthetic */ BitArraySetN $outer;

            private void advanceIterator() {
                int[] set = this.$outer.set();
                int bucket = -1;
                do {
                    ++this.i;
                    bucket = this.i / 32;
                } while (this.i < this.max && (set[bucket] & 1 << this.i - 32 * bucket) == 0);
            }

            public boolean hasNext() {
                return this.i < this.max;
            }

            public int next() {
                int i = this.i;
                this.advanceIterator();
                return i;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.max = $outer.set().length * 32;
                this.i = -1;
                this.advanceIterator();
            }
        };
    }

    @Override
    public boolean equals(Object other) {
        Object object = other;
        if (object instanceof BitArraySetN) {
            BitArraySetN bitArraySetN = (BitArraySetN)object;
            return Arrays.equals(this.set(), bitArraySetN.set());
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode(this.set());
    }

    public BitArraySetN(int[] set) {
        this.set = set;
    }
}

