/*
 * Decompiled with CFR 0.152.
 */
package org.opalj.cli;

import java.io.File;
import java.io.Serializable;
import org.opalj.cli.ParsedArg;
import org.opalj.log.GlobalLogContext$;
import org.opalj.log.OPALLogger$;
import org.rogach.scallop.package$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.ArrayOps$;
import scala.collection.Iterable;
import scala.collection.immutable.ArraySeq$;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005E3QAB\u0004\u0002\u00029AQ!\r\u0001\u0005\u0002IBQ\u0001\u000e\u0001\u0005BUBQ\u0001\u000f\u0001\u0005\neBQA\u0011\u0001\u0005\n\rCQA\u0013\u0001\u0005\n-\u0013\u0001c\u00117bgN\u0004\u0016\r\u001e5MS.,\u0017I]4\u000b\u0005!I\u0011aA2mS*\u0011!bC\u0001\u0006_B\fGN\u001b\u0006\u0002\u0019\u0005\u0019qN]4\u0004\u0001M\u0011\u0001a\u0004\t\u0005!E\u0019\u0002%D\u0001\b\u0013\t\u0011rAA\u0005QCJ\u001cX\rZ!sOB\u0011A#\b\b\u0003+m\u0001\"AF\r\u000e\u0003]Q!\u0001G\u0007\u0002\rq\u0012xn\u001c;?\u0015\u0005Q\u0012!B:dC2\f\u0017B\u0001\u000f\u001a\u0003\u0019\u0001&/\u001a3fM&\u0011ad\b\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005qI\u0002cA\u0011'S9\u0011!\u0005\n\b\u0003-\rJ\u0011AG\u0005\u0003Ke\tq\u0001]1dW\u0006<W-\u0003\u0002(Q\tA\u0011\n^3sC\ndWM\u0003\u0002&3A\u0011!fL\u0007\u0002W)\u0011A&L\u0001\u0003S>T\u0011AL\u0001\u0005U\u00064\u0018-\u0003\u00021W\t!a)\u001b7f\u0003\u0019a\u0014N\\5u}Q\t1\u0007\u0005\u0002\u0011\u0001\u0005)\u0001/\u0019:tKR\u0011\u0001E\u000e\u0005\u0006o\t\u0001\raE\u0001\u0004CJ<\u0017a\u0003<fe&4\u0017PR5mKN$\"AO\u001f\u0011\u0007\u0005Z\u0014&\u0003\u0002=Q\t\u00191+Z9\t\u000by\u001a\u0001\u0019A \u0002\u0013\u0019LG.\u001a8b[\u0016\u001c\bcA\u0011A'%\u0011\u0011\t\u000b\u0002\u000b\u0013:$W\r_3e'\u0016\f\u0018A\u0003<fe&4\u0017PR5mKR\u0011A\t\u0013\t\u0004\u000b\u001aKS\"A\r\n\u0005\u001dK\"AB(qi&|g\u000eC\u0003J\t\u0001\u00071#\u0001\u0005gS2,g.Y7f\u0003%\u0019\bn\\<FeJ|'\u000f\u0006\u0002M\u001fB\u0011Q)T\u0005\u0003\u001df\u0011A!\u00168ji\")\u0001+\u0002a\u0001'\u00059Q.Z:tC\u001e,\u0007")
public abstract class ClassPathLikeArg
extends ParsedArg<String, Iterable<File>> {
    @Override
    public Iterable<File> parse(String arg) {
        IndexedSeq<String> cp = (IndexedSeq<String>)scala.package$.MODULE$.IndexedSeq().empty();
        cp = ArrayOps$.MODULE$.toIndexedSeq$extension(Predef$.MODULE$.refArrayOps(arg.split(File.pathSeparator)));
        if (cp.isEmpty()) {
            cp = ArraySeq$.MODULE$.unsafeWrapArray(new String[]{System.getProperty("user.dir")});
        }
        OPALLogger$.MODULE$.info("project configuration", new StringBuilder(8).append("the ").append(this.argName()).append(" is ").append(cp.mkString()).toString(), GlobalLogContext$.MODULE$);
        return this.verifyFiles(cp);
    }

    private Seq<File> verifyFiles(IndexedSeq<String> filenames) {
        return (Seq)filenames.flatMap((Function1<String, Option> & Serializable)filename -> this.verifyFile((String)filename));
    }

    private Option<File> verifyFile(String filename) {
        File file = new File(filename);
        if (!file.exists()) {
            this.showError(new StringBuilder(23).append("File does not exist: ").append(file).append(" ").append(ClassPathLikeArg.workingDirectory$1()).append(".").toString());
            return None$.MODULE$;
        }
        if (!file.canRead()) {
            this.showError(new StringBuilder(15).append("Cannot read: ").append(file).append(" ").append(ClassPathLikeArg.workingDirectory$1()).append(".").toString());
            return None$.MODULE$;
        }
        if (!(file.isDirectory() || filename.endsWith(".jar") || filename.endsWith(".ear") || filename.endsWith(".war") || filename.endsWith(".zip") || filename.endsWith(".jmod") || filename.endsWith(".class"))) {
            this.showError(new StringBuilder(65).append("Input file is neither a directory nor a class or JAR/JMod file: ").append(file).append(".").toString());
            return None$.MODULE$;
        }
        return new Some<File>(file);
    }

    private void showError(String message) {
        OPALLogger$.MODULE$.error("project configuration", message, GlobalLogContext$.MODULE$);
    }

    private static final String workingDirectory$1() {
        return new StringBuilder(21).append("(working directory: ").append(System.getProperty("user.dir")).append(")").toString();
    }

    public ClassPathLikeArg() {
        super(package$.MODULE$.stringConverter());
    }
}

