/*
 * Decompiled with CFR 0.152.
 */
package org.opalj.bi.reader;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URI;
import java.net.URL;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Enumeration;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.commons.text.similarity.LevenshteinDistance;
import org.opalj.bi.AttributesParent$;
import org.opalj.bi.package$;
import org.opalj.bi.reader.ClassFileReader$;
import org.opalj.bi.reader.ClassFileReaderConfiguration;
import org.opalj.bi.reader.ConstantPoolEntry;
import org.opalj.bi.reader.Constant_PoolAbstractions;
import org.opalj.bytecode.BytecodeProcessingFailedException;
import org.opalj.collection.immutable.UShortPair$;
import org.opalj.concurrent.Tasks;
import org.opalj.concurrent.Tasks$;
import org.opalj.log.OPALLogger$;
import org.opalj.log.Warn$;
import scala.Array$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.AbstractIterable;
import scala.collection.ArrayOps$;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.$colon$colon;
import scala.collection.immutable.ArraySeq;
import scala.collection.immutable.ArraySeq$;
import scala.collection.immutable.LazyList;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.concurrent.Await$;
import scala.concurrent.ExecutionContext$;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.Duration$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.Nothing$;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scala.util.control.ControlThrowable;

@ScalaSignature(bytes="\u0006\u0005\ruba\u0002\u00180!\u0003\r\t\u0001\u000f\u0005\u0006\r\u0002!\ta\u0012\u0003\u0006\u0017\u0002\u0011\t\u0001T\u0003\u0005'\u0002\u0011A\u000bB\u0003\\\u0001\t\u0005A\nB\u0003]\u0001\t\u0005A\nB\u0003^\u0001\t\u0005A\nC\u0003_\u0001\u0019Eq\fC\u0003n\u0001\u0019Ea\u000eC\u0003t\u0001\u0019EA\u000fC\u0003y\u0001\u0019E\u0011\u0010C\u0004\u0002\u0018\u00011\t\"!\u0007\t\u0013\u0005-\u0003A1A\u0005\u0006\u00055\u0003\"CAK\u0001\u0001\u0007K\u0011BAL\u0011%\t)\f\u0001a!\n\u0013\t9\fC\u0004\u0002>\u0002!\t!a0\t\u000f\u0005]\u0001\u0001\"\u0001\u0002F\"9\u0011q\u0003\u0001\u0005\u0002\u0005%\u0007bBAn\u0001\u0011\u0005\u0011Q\u001c\u0005\t\u0003/\u0001\u0001\u0015\"\u0005\u0003\u0004!9\u0011q\u0003\u0001\u0005\u0002\t\r\u0002bBA\f\u0001\u0011\u0005!1\t\u0005\b\u0005\u001b\u0002A\u0011\u0001B(\u0011\u001d\u0011i\u0005\u0001C\u0001\u0005WBqA!\u0014\u0001\t\u0003\u0011)\tC\u0004\u0003N\u0001!IAa%\t\u000f\t5\u0003\u0001\"\u0003\u0003 \"A!1\u0017\u0001!\n\u0013\u0011)\fC\u0005\u0003>\u0002\t\n\u0011\"\u0003\u0003@\"A!Q\u001b\u0001!\n\u0013\u00119\u000eC\u0005\u0003^\u0002\t\n\u0011\"\u0003\u0003@\"9!Q\n\u0001\u0005\u0002\t}\u0007\"\u0003Bs\u0001E\u0005I\u0011\u0001B`\u0011\u001d\u00119\u000f\u0001C\u0001\u0005SD\u0011B!?\u0001#\u0003%\tAa0\t\u000f\tm\b\u0001\"\u0001\u0003~\"911\u0001\u0001\u0005\u0002\r\u0015\u0001\"CB\f\u0001E\u0005I\u0011\u0001B`\u0011\u001d\u0019I\u0002\u0001C\u0001\u00077A\u0011ba\u000f\u0001#\u0003%\tAa0\b\u000f\u0005%t\u0006#\u0001\u0002l\u00191af\fE\u0001\u0003[Bq!a\u001c*\t\u0003\t\t(\u0002\u0004\u0002t%\u0002\u0011Q\u000f\u0005\n\u0003\u0017K#\u0019!C\u0003\u0003\u001bC\u0001\"a%*A\u00035\u0011q\u0012\u0002\u0010\u00072\f7o\u001d$jY\u0016\u0014V-\u00193fe*\u0011\u0001'M\u0001\u0007e\u0016\fG-\u001a:\u000b\u0005I\u001a\u0014A\u00012j\u0015\t!T'A\u0003pa\u0006d'NC\u00017\u0003\ry'oZ\u0002\u0001'\u0011\u0001\u0011hP\"\u0011\u0005ijT\"A\u001e\u000b\u0003q\nQa]2bY\u0006L!AP\u001e\u0003\r\u0005s\u0017PU3g!\t\u0001\u0015)D\u00010\u0013\t\u0011uF\u0001\u000fDY\u0006\u001c8OR5mKJ+\u0017\rZ3s\u0007>tg-[4ve\u0006$\u0018n\u001c8\u0011\u0005\u0001#\u0015BA#0\u0005e\u0019uN\\:uC:$x\fU8pY\u0006\u00137\u000f\u001e:bGRLwN\\:\u0002\r\u0011Jg.\u001b;%)\u0005A\u0005C\u0001\u001eJ\u0013\tQ5H\u0001\u0003V]&$(!C\"mCN\u001ch)\u001b7f#\ti\u0005\u000b\u0005\u0002;\u001d&\u0011qj\u000f\u0002\b\u001d>$\b.\u001b8h!\tQ\u0014+\u0003\u0002Sw\t\u0019\u0011I\\=\u0003\u0015%sG/\u001a:gC\u000e,7\u000fE\u0002;+^K!AV\u001e\u0003\u000b\u0005\u0013(/Y=\u0011\u0005aKV\"\u0001\u0001\n\u0005i#%aE\"p]N$\u0018M\u001c;`!>|GnX%oI\u0016D(A\u0002$jK2$7OA\u0004NKRDw\u000eZ:\u0003\u0015\u0005#HO]5ckR,7/A\u0007D_:\u001cH/\u00198u?B{w\u000e\u001c\u000b\u0003A\u000e\u0004\"\u0001W1\n\u0005\t$%!D\"p]N$\u0018M\u001c;`!>|G\u000eC\u0003e\u000f\u0001\u0007Q-\u0001\u0002j]B\u0011am[\u0007\u0002O*\u0011\u0001.[\u0001\u0003S>T\u0011A[\u0001\u0005U\u00064\u0018-\u0003\u0002mO\nyA)\u0019;b\u0013:\u0004X\u000f^*ue\u0016\fW.\u0001\u0004GS\u0016dGm\u001d\u000b\u0004_B\u0014\bC\u0001-\u0005\u0011\u0015\t\b\u00021\u0001a\u0003\t\u0019\u0007\u000fC\u0003e\u0011\u0001\u0007Q-A\u0004NKRDw\u000eZ:\u0015\u0007U4x\u000f\u0005\u0002Y\u000b!)\u0011/\u0003a\u0001A\")A-\u0003a\u0001K\u0006Q\u0011\t\u001e;sS\n,H/Z:\u0015\u0013i\\H0!\u0004\u0002\u0012\u0005U\u0001C\u0001-\u0007\u0011\u0015\t(\u00021\u0001a\u0011\u0015i(\u00021\u0001\u007f\u0003\t\t\u0007\u000fE\u0002\u0000\u0003\u000fqA!!\u0001\u0002\u00045\t\u0011'C\u0002\u0002\u0006E\nq\u0001]1dW\u0006<W-\u0003\u0003\u0002\n\u0005-!aD!uiJL'-\u001e;f!\u0006\u0014XM\u001c;\u000b\u0007\u0005\u0015\u0011\u0007\u0003\u0004\u0002\u0010)\u0001\raV\u0001\u000eCB|f.Y7f?&tG-\u001a=\t\r\u0005M!\u00021\u0001X\u0003M\t\u0007o\u00183fg\u000e\u0014\u0018\u000e\u001d;pe~Kg\u000eZ3y\u0011\u0015!'\u00021\u0001f\u0003%\u0019E.Y:t\r&dW\r\u0006\f\u0002\u001c\u0005u\u0011qDA\u0015\u0003[\t\t$!\u000e\u0002:\u0005}\u00121IA$!\tA&\u0001C\u0003r\u0017\u0001\u0007\u0001\rC\u0004\u0002\"-\u0001\r!a\t\u0002\u001b5Lgn\u001c:`m\u0016\u00148/[8o!\rQ\u0014QE\u0005\u0004\u0003OY$aA%oi\"9\u00111F\u0006A\u0002\u0005\r\u0012!D7bU>\u0014xL^3sg&|g\u000eC\u0004\u00020-\u0001\r!a\t\u0002\u0019\u0005\u001c7-Z:t?\u001ad\u0017mZ:\t\r\u0005M2\u00021\u0001X\u0003)!\b.[:`G2\f7o\u001d\u0005\u0007\u0003oY\u0001\u0019A,\u0002\u0017M,\b/\u001a:`G2\f7o\u001d\u0005\b\u0003wY\u0001\u0019AA\u001f\u0003)Ig\u000e^3sM\u0006\u001cWm\u001d\t\u00031\u000eAa!!\u0011\f\u0001\u0004y\u0017A\u00024jK2$7\u000f\u0003\u0004\u0002F-\u0001\r!^\u0001\b[\u0016$\bn\u001c3t\u0011\u0019\tIe\u0003a\u0001u\u0006Q\u0011\r\u001e;sS\n,H/Z:\u0002/\u0011,g-Y;mi\u0016C8-\u001a9uS>t\u0007*\u00198eY\u0016\u0014XCAA(!\r\t\tf\u000b\b\u0004\u0003'Bc\u0002BA+\u0003OrA!a\u0016\u0002f9!\u0011\u0011LA2\u001d\u0011\tY&!\u0019\u000e\u0005\u0005u#bAA0o\u00051AH]8pizJ\u0011AN\u0005\u0003iUJ!AM\u001a\n\u0005A\n\u0014aD\"mCN\u001ch)\u001b7f%\u0016\fG-\u001a:\u0011\u0005\u0001K3CA\u0015:\u0003\u0019a\u0014N\\5u}Q\u0011\u00111\u000e\u0002\u0011\u000bb\u001cW\r\u001d;j_:D\u0015M\u001c3mKJ\u0004rAOA<s\u0005m\u0004*C\u0002\u0002zm\u0012\u0011BR;oGRLwN\u001c\u001a\u0011\t\u0005u\u0014Q\u0011\b\u0005\u0003\u007f\n\u0019I\u0004\u0003\u0002\\\u0005\u0005\u0015\"\u0001\u001f\n\u0007\u0005\u00151(\u0003\u0003\u0002\b\u0006%%!\u0003+ie><\u0018M\u00197f\u0015\r\t)aO\u0001\u0019'V\u0004\bO]3tg\u0016C8-\u001a9uS>t\u0007*\u00198eY\u0016\u0014XCAAH!\r\t\tjK\u0007\u0002S\u0005I2+\u001e9qe\u0016\u001c8/\u0012=dKB$\u0018n\u001c8IC:$G.\u001a:!\u0003]\u0019G.Y:t\r&dW\rU8tiB\u0013xnY3tg>\u00148/\u0006\u0002\u0002\u001aB1\u00111TAS\u0003Sk!!!(\u000b\t\u0005}\u0015\u0011U\u0001\nS6lW\u000f^1cY\u0016T1!a)<\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003O\u000biJ\u0001\u0005BeJ\f\u0017pU3r!\u001dQ\u00141VAX\u0003_K1!!,<\u0005%1UO\\2uS>t\u0017\u0007\u0005\u0004\u0002~\u0005E\u00161D\u0005\u0005\u0003g\u000bII\u0001\u0003MSN$\u0018aG2mCN\u001ch)\u001b7f!>\u001cH\u000f\u0015:pG\u0016\u001c8o\u001c:t?\u0012*\u0017\u000fF\u0002I\u0003sC\u0011\"a/\u000f\u0003\u0003\u0005\r!!'\u0002\u0007a$\u0013'\u0001\u0010sK\u001eL7\u000f^3s\u00072\f7o\u001d$jY\u0016\u0004vn\u001d;Qe>\u001cWm]:peR\u0019\u0001*!1\t\u000f\u0005\rw\u00021\u0001\u0002*\u0006\t\u0001\u000f\u0006\u0003\u00020\u0006\u001d\u0007\"\u00023\u0011\u0001\u0004)G\u0003BAX\u0003\u0017Dq!!4\u0012\u0001\u0004\ty-\u0001\u0004de\u0016\fG/\u001a\t\u0006u\u0005E\u0017Q[\u0005\u0004\u0003'\\$!\u0003$v]\u000e$\u0018n\u001c81!\r1\u0017q[\u0005\u0004\u00033<'aC%oaV$8\u000b\u001e:fC6\fQ#[:DY\u0006\u001c8OR5mKJ+\u0007o\\:ji>\u0014\u0018\u0010\u0006\u0004\u0002`\u0006\u0015\u0018\u0011 \t\u0004u\u0005\u0005\u0018bAArw\t9!i\\8mK\u0006t\u0007bBAt%\u0001\u0007\u0011\u0011^\u0001\tM&dWM\\1nKB!\u00111^Az\u001d\u0011\ti/a<\u0011\u0007\u0005m3(C\u0002\u0002rn\na\u0001\u0015:fI\u00164\u0017\u0002BA{\u0003o\u0014aa\u0015;sS:<'bAAyw!9\u00111 \nA\u0002\u0005u\u0018!D2p]R\f\u0017N\\3s\u001d\u0006lW\rE\u0003;\u0003\u007f\fI/C\u0002\u0003\u0002m\u0012aa\u00149uS>tGCBAX\u0005\u000b\u0011I\u0002C\u0004\u0003\bM\u0001\rA!\u0003\u0002\u000f)\f'OR5mKB!!1\u0002B\u000b\u001b\t\u0011iA\u0003\u0003\u0003\u0010\tE\u0011a\u0001>ja*\u0019!1C5\u0002\tU$\u0018\u000e\\\u0005\u0005\u0005/\u0011iAA\u0004[SB4\u0015\u000e\\3\t\u000f\tm1\u00031\u0001\u0003\u001e\u0005A!.\u0019:F]R\u0014\u0018\u0010\u0005\u0003\u0003\f\t}\u0011\u0002\u0002B\u0011\u0005\u001b\u0011\u0001BW5q\u000b:$(/\u001f\u000b\u0007\u0003_\u0013)C!\f\t\u000f\t\u001dA\u00031\u0001\u0003(A\u0019aM!\u000b\n\u0007\t-rM\u0001\u0003GS2,\u0007b\u0002B\u0018)\u0001\u0007\u0011\u0011^\u0001\u0011U\u0006\u0014h)\u001b7f\u000b:$(/\u001f(b[\u0016DS\u0001\u0006B\u001a\u0005\u007f\u0001RA\u000fB\u001b\u0005sI1Aa\u000e<\u0005\u0019!\bN]8xgB\u0019aMa\u000f\n\u0007\turMA\u0006J\u001f\u0016C8-\u001a9uS>t\u0017E\u0001B!\u0003EJg\r\t;iK\u00022\u0017\u000e\\3!SN\u0004S-\u001c9us\u0002z'\u000f\t;iK\u0002*g\u000e\u001e:zA\r\fgN\\8uA\t,\u0007EZ8v]\u0012$b!a,\u0003F\t%\u0003b\u0002B$+\u0001\u0007\u0011\u0011^\u0001\fU\u0006\u0014h)\u001b7f\u001d\u0006lW\rC\u0004\u00030U\u0001\r!!;)\u000bU\u0011\u0019Da\u0010\u0002\u0015\rc\u0017m]:GS2,7\u000f\u0006\u0004\u0003R\t\u0015$q\r\t\u0007\u0003{\n\tLa\u0015\u0011\u000fi\u0012)&a\u0007\u0003Z%\u0019!qK\u001e\u0003\rQ+\b\u000f\\33!\u0011\u0011YF!\u0019\u000e\u0005\tu#b\u0001B0S\u0006\u0019a.\u001a;\n\t\t\r$Q\f\u0002\u0004+Jc\u0005b\u0002B\u0004-\u0001\u0007!\u0011\u0002\u0005\b\u0005S2\u0002\u0019AA(\u0003A)\u0007pY3qi&|g\u000eS1oI2,'\u000f\u0006\u0003\u0003n\tE\u0004CBA?\u0003c\u0013y\u0007E\u0004;\u0005+\nY\"!;\t\u000f\u0011<B\u00111\u0001\u0003tA)!H!\u001e\u0003z%\u0019!qO\u001e\u0003\u0011q\u0012\u0017P\\1nKz\u0002BAa\u001f\u0003\u00026\u0011!Q\u0010\u0006\u0005\u0005\u007f\u0012\t\"A\u0002kCJLAAa!\u0003~\tq!*\u0019:J]B,Ho\u0015;sK\u0006lGc\u0002%\u0003\b\n-%\u0011\u0013\u0005\b\u0005\u0013C\u0002\u0019\u0001B\u0005\u0003\u001dQ\u0018\u000e\u001d$jY\u0016DqA!$\u0019\u0001\u0004\u0011y)\u0001\tdY\u0006\u001c8OR5mK\"\u000bg\u000e\u001a7feBA!(a\u001e\u0002\u001c\te\u0003\nC\u0004\u0003ja\u0001\r!a\u0014\u0015\u0013!\u0013)J!'\u0003\u001c\nu\u0005b\u0002BL3\u0001\u0007\u0011\u0011^\u0001\u000bU\u0006\u0014h)\u001b7f+Jc\u0005b\u0002B\u00043\u0001\u0007!\u0011\u0002\u0005\b\u0005\u001bK\u0002\u0019\u0001BH\u0011\u001d\u0011I'\u0007a\u0001\u0003\u001f\"\u0012\u0002\u0013BQ\u0005G\u0013yK!-\t\u000f\t]%\u00041\u0001\u0002j\"9!Q\u0015\u000eA\u0002\t\u001d\u0016a\u00026be\u0012\u000bG/\u0019\t\u0005uU\u0013I\u000bE\u0002;\u0005WK1A!,<\u0005\u0011\u0011\u0015\u0010^3\t\u000f\t5%\u00041\u0001\u0003\u0010\"9!\u0011\u000e\u000eA\u0002\u0005=\u0013A\u00039s_\u000e,7o\u001d&beR1!\u0011\u000bB\\\u0005wCqA!/\u001c\u0001\u0004\u00119#\u0001\u0003gS2,\u0007\"\u0003B57A\u0005\t\u0019AA(\u0003Q\u0001(o\\2fgNT\u0015M\u001d\u0013eK\u001a\fW\u000f\u001c;%eU\u0011!\u0011\u0019\u0016\u0005\u0003\u001f\u0012\u0019m\u000b\u0002\u0003FB!!q\u0019Bi\u001b\t\u0011IM\u0003\u0003\u0003L\n5\u0017!C;oG\",7m[3e\u0015\r\u0011ymO\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002\u0002Bj\u0005\u0013\u0014\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0003A\u0001(o\\2fgN\u001cE.Y:t\r&dW\r\u0006\u0004\u0003R\te'1\u001c\u0005\b\u0005sk\u0002\u0019\u0001B\u0014\u0011%\u0011I'\bI\u0001\u0002\u0004\ty%\u0001\u000eqe>\u001cWm]:DY\u0006\u001c8OR5mK\u0012\"WMZ1vYR$#\u0007\u0006\u0004\u0003R\t\u0005(1\u001d\u0005\b\u0005s{\u0002\u0019\u0001B\u0014\u0011%\u0011Ig\bI\u0001\u0002\u0004\ty%\u0001\u000bDY\u0006\u001c8OR5mKN$C-\u001a4bk2$HEM\u0001\u000e\u00032d7\t\\1tg\u001aKG.Z:\u0015\r\t-(\u0011\u001fB|!\u0019\tiH!<\u0003T%!!q^AE\u0005!IE/\u001a:bE2,\u0007b\u0002BzC\u0001\u0007!Q_\u0001\u0006M&dWm\u001d\t\u0007\u0003{\u0012iOa\n\t\u0013\t%\u0014\u0005%AA\u0002\u0005=\u0013aF!mY\u000ec\u0017m]:GS2,7\u000f\n3fM\u0006,H\u000e\u001e\u00133\u00035Q%\u000bV\"mCN\u001ch)\u001b7fgV\u0011!q \t\u0007\u0003{\u0012io!\u0001\u0011\u000fi\u0012)&!;\u0003R\u0005\t\u0002O]8dKN\u001c8\t\\1tg\u001aKG.Z:\u0015\u0013!\u001b9a!\u0003\u0004\u0010\rU\u0001b\u0002BzI\u0001\u0007!Q\u001f\u0005\b\u0007\u0017!\u0003\u0019AB\u0007\u0003A\u0001(o\\4sKN\u001c(+\u001a9peR,'\u000f\u0005\u0004;\u0003W\u00139\u0003\u0013\u0005\b\u0007#!\u0003\u0019AB\n\u0003I\u0019G.Y:t\r&dW\r\u0015:pG\u0016\u001c8o\u001c:\u0011\ri\nYKa\u0015I\u0011%\u0011I\u0007\nI\u0001\u0002\u0004\ty%A\u000eqe>\u001cWm]:DY\u0006\u001c8OR5mKN$C-\u001a4bk2$H\u0005N\u0001\u000eM&tGm\u00117bgN4\u0015\u000e\\3\u0015\u0019\ru1\u0011FB\u0016\u0007[\u0019\u0019d!\u000f\u0011\u0011\u0005u4q\u0004B*\u0007GIAa!\t\u0002\n\n1Q)\u001b;iKJ\u0004b!a;\u0004&\u0005%\u0018\u0002BB\u0014\u0003o\u00141aU3u\u0011\u001d\u0011\u0019P\na\u0001\u0005kDqaa\u0003'\u0001\u0004\u0019i\u0001C\u0004\u00040\u0019\u0002\ra!\r\u0002\u001f\rd\u0017m]:GS2,g)\u001b7uKJ\u0004rAOAV\u00037\ty\u000eC\u0004\u00046\u0019\u0002\raa\u000e\u0002\u0013\rd\u0017m]:OC6,\u0007c\u0002\u001e\u0002,\u0006m\u0011\u0011\u001e\u0005\n\u0005S2\u0003\u0013!a\u0001\u0003\u001f\nqCZ5oI\u000ec\u0017m]:GS2,G\u0005Z3gCVdG\u000fJ\u001b")
public interface ClassFileReader
extends ClassFileReaderConfiguration,
Constant_PoolAbstractions {
    public static Function2<Object, Throwable, BoxedUnit> SuppressExceptionHandler() {
        return ClassFileReader$.MODULE$.SuppressExceptionHandler();
    }

    public void org$opalj$bi$reader$ClassFileReader$_setter_$defaultExceptionHandler_$eq(Function2<Object, Throwable, BoxedUnit> var1);

    public ConstantPoolEntry[] Constant_Pool(DataInputStream var1);

    public Object Fields(ConstantPoolEntry[] var1, DataInputStream var2);

    public Object Methods(ConstantPoolEntry[] var1, DataInputStream var2);

    public Object Attributes(ConstantPoolEntry[] var1, Enumeration.Value var2, int var3, int var4, DataInputStream var5);

    public Object ClassFile(ConstantPoolEntry[] var1, int var2, int var3, int var4, int var5, int var6, int[] var7, Object var8, Object var9, Object var10);

    public Function2<Object, Throwable, BoxedUnit> defaultExceptionHandler();

    public ArraySeq<Function1<List<Object>, List<Object>>> org$opalj$bi$reader$ClassFileReader$$classFilePostProcessors();

    public void org$opalj$bi$reader$ClassFileReader$$classFilePostProcessors_$eq(ArraySeq<Function1<List<Object>, List<Object>>> var1);

    public static /* synthetic */ void registerClassFilePostProcessor$(ClassFileReader $this, Function1 p) {
        $this.registerClassFilePostProcessor(p);
    }

    default public void registerClassFilePostProcessor(Function1<List<Object>, List<Object>> p) {
        this.org$opalj$bi$reader$ClassFileReader$$classFilePostProcessors_$eq((ArraySeq)this.org$opalj$bi$reader$ClassFileReader$$classFilePostProcessors().$colon$plus(p));
    }

    public static /* synthetic */ List ClassFile$(ClassFileReader $this, DataInputStream in) {
        return $this.ClassFile(in);
    }

    default public List<Object> ClassFile(DataInputStream in) {
        int[] nArray;
        int readMagic = in.readInt();
        if (-889275714 != readMagic) {
            throw new BytecodeProcessingFailedException("the file does not start with 0xCAFEBABE");
        }
        int minor_version = in.readUnsignedShort();
        int major_version = in.readUnsignedShort();
        if (major_version < 45) {
            throw new BytecodeProcessingFailedException(ClassFileReader.unsupportedVersion$1(major_version, minor_version));
        }
        if (major_version > 69 || major_version == 69 && minor_version > UShortPair$.MODULE$.minor$extension(package$.MODULE$.LatestSupportedJavaVersion())) {
            OPALLogger$.MODULE$.logOnce(Warn$.MODULE$.apply("class file reader", ClassFileReader.unsupportedVersion$1(major_version, minor_version)), this.logContext());
        }
        ConstantPoolEntry[] cp = this.Constant_Pool(in);
        int access_flags = in.readUnsignedShort();
        int this_class = in.readUnsignedShort();
        int super_class = in.readUnsignedShort();
        int interfaces_count = in.readUnsignedShort();
        int size = interfaces_count;
        if (size == 0) {
            nArray = (int[])Array$.MODULE$.empty(Predef$.MODULE$.implicitly(ClassTag$.MODULE$.Int()));
        } else {
            int[] array = new int[size];
            for (int i = 0; i < size; ++i) {
                int value;
                array[i] = value = in.readUnsignedShort();
            }
            nArray = array;
        }
        int[] interfaces = nArray;
        Object fields = this.Fields(cp, in);
        Object methods = this.Methods(cp, in);
        Object attributes = this.Attributes(cp, AttributesParent$.MODULE$.ClassFile(), this_class, -1, in);
        Object classFile = this.ClassFile(cp, minor_version, major_version, access_flags, this_class, super_class, interfaces, fields, methods, attributes);
        classFile = this.applyDeferredActions(cp, classFile);
        return (List)this.org$opalj$bi$reader$ClassFileReader$$classFilePostProcessors().foldLeft(scala.package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray(new Object[]{classFile})), (Function2<List, Function1, List> & Serializable)(classFiles, postProcessor) -> (List)postProcessor.apply(classFiles));
    }

    public static /* synthetic */ List ClassFile$(ClassFileReader $this, Function0 create) {
        return $this.ClassFile(create);
    }

    default public List<Object> ClassFile(Function0<InputStream> create) {
        return (List)org.opalj.io.package$.MODULE$.process((Closeable)create.apply(), (Function1<InputStream, List> & Serializable)x0$1 -> {
            InputStream inputStream = x0$1;
            if (inputStream == null) {
                throw new IllegalArgumentException("the created stream is null");
            }
            if (inputStream instanceof DataInputStream) {
                DataInputStream dataInputStream = (DataInputStream)inputStream;
                return this.ClassFile(dataInputStream);
            }
            if (inputStream instanceof BufferedInputStream) {
                BufferedInputStream bufferedInputStream = (BufferedInputStream)inputStream;
                return this.ClassFile(new DataInputStream(bufferedInputStream));
            }
            if (inputStream instanceof ByteArrayInputStream) {
                ByteArrayInputStream byteArrayInputStream = (ByteArrayInputStream)inputStream;
                return this.ClassFile(new DataInputStream(byteArrayInputStream));
            }
            return this.ClassFile(new DataInputStream(new BufferedInputStream(inputStream)));
        });
    }

    public static /* synthetic */ boolean isClassFileRepository$(ClassFileReader $this, String filename, Option containerName) {
        return $this.isClassFileRepository(filename, containerName);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    default public boolean isClassFileRepository(String filename, Option<String> containerName) {
        String ending;
        int containerNameLength;
        if (containerName.isDefined() && (containerNameLength = containerName.get().length()) > 5 && containerName.get().endsWith(".jmod")) {
            return false;
        }
        int filenameLength = filename.length();
        if (filenameLength <= 4) return false;
        String string = ending = filename.substring(filenameLength - 4, filenameLength).toLowerCase();
        String string2 = "jmod";
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            if (filename.charAt(filenameLength - 5) == '.') return true;
        }
        String string3 = ending;
        String string4 = ".jar";
        if (string3 == null) {
            if (string4 == null) return true;
        } else if (string3.equals(string4)) return true;
        String string5 = ending;
        String string6 = ".zip";
        if (string5 == null) {
            if (string6 == null) return true;
        } else if (string5.equals(string6)) return true;
        String string7 = ending;
        String string8 = ".war";
        if (string7 == null) {
            if (string8 == null) return true;
        } else if (string7.equals(string8)) return true;
        String string9 = ending;
        String string10 = ".ear";
        if (string9 != null) {
            if (!string9.equals(string10)) return false;
            return true;
        }
        if (string10 == null) return true;
        return false;
    }

    public static /* synthetic */ List ClassFile$(ClassFileReader $this, ZipFile jarFile, ZipEntry jarEntry) {
        return $this.ClassFile(jarFile, jarEntry);
    }

    default public List<Object> ClassFile(ZipFile jarFile, ZipEntry jarEntry) {
        return (List)org.opalj.io.package$.MODULE$.process(jarFile.getInputStream(jarEntry), (Function1<InputStream, List> & Serializable)in -> this.ClassFile(new DataInputStream(new BufferedInputStream((InputStream)in))));
    }

    public static /* synthetic */ List ClassFile$(ClassFileReader $this, File jarFile, String jarFileEntryName) {
        return $this.ClassFile(jarFile, jarFileEntryName);
    }

    default public List<Object> ClassFile(File jarFile, String jarFileEntryName) throws IOException {
        if (jarFile.length() == 0L) {
            throw new IOException(new StringBuilder(18).append("the file ").append(jarFile).append(" is empty").toString());
        }
        LevenshteinDistance levenshteinDistance = new LevenshteinDistance();
        return (List)org.opalj.io.package$.MODULE$.process(new ZipFile(jarFile), (Function1<ZipFile, List> & Serializable)zf -> {
            ZipEntry jarEntry = zf.getEntry(jarFileEntryName);
            if (jarEntry == null) {
                List names = Nil$.MODULE$;
                Enumeration<? extends ZipEntry> zfEntries = zf.entries();
                while (zfEntries.hasMoreElements()) {
                    ZipEntry zfEntry = zfEntries.nextElement();
                    String zfEntryName = zfEntry.getName();
                    int distance = levenshteinDistance.apply(zfEntryName, jarFileEntryName);
                    Tuple2<Integer, String> tuple2 = new Tuple2<Integer, String>(BoxesRunTime.boxToInteger(distance), zfEntryName);
                    names = names.$colon$colon(tuple2);
                }
                Object mostRelatedNames = ((List)((List)names.sortWith((Function2<Tuple2, Tuple2, Object> & Serializable)(l, r) -> BoxesRunTime.boxToBoolean(ClassFileReader.$anonfun$ClassFile$5(l, r)))).map((Function1<Tuple2, String> & Serializable)x$1 -> (String)x$1._2())).take(15);
                String ending = ((List)mostRelatedNames).length() > 15 ? ", ...)" : ")";
                String messageHeader = new StringBuilder(27).append("the file ").append(jarFile).append(" does not contain ").append(jarFileEntryName).toString();
                String message = ((AbstractIterable)mostRelatedNames).mkString(new StringBuilder(11).append(messageHeader).append(" (similar: ").toString(), ", ", ending);
                throw new IOException(message);
            }
            return this.ClassFile((ZipFile)zf, jarEntry);
        });
    }

    public static /* synthetic */ List ClassFile$(ClassFileReader $this, String jarFileName, String jarFileEntryName) {
        return $this.ClassFile(jarFileName, jarFileEntryName);
    }

    default public List<Object> ClassFile(String jarFileName, String jarFileEntryName) throws IOException {
        return this.ClassFile(new File(jarFileName), jarFileEntryName);
    }

    public static /* synthetic */ List ClassFiles$(ClassFileReader $this, ZipFile jarFile, Function2 exceptionHandler) {
        return $this.ClassFiles(jarFile, (Function2<Object, Throwable, BoxedUnit>)exceptionHandler);
    }

    default public List<Tuple2<Object, URL>> ClassFiles(ZipFile jarFile, Function2<Object, Throwable, BoxedUnit> exceptionHandler) {
        Object Lock2 = new Object();
        ObjectRef<Nil$> classFiles = ObjectRef.create(Nil$.MODULE$);
        this.ClassFiles(jarFile, (Function2<Object, URL, BoxedUnit>)(Function2<Object, URL, Object> & Serializable)(cf, url) -> {
            ClassFileReader.addClassFile$1(cf, url, Lock2, classFiles);
            return BoxedUnit.UNIT;
        }, exceptionHandler);
        return (List)classFiles.elem;
    }

    public static /* synthetic */ List ClassFiles$(ClassFileReader $this, Function0 in) {
        return $this.ClassFiles(in);
    }

    default public List<Tuple2<Object, String>> ClassFiles(Function0<JarInputStream> in2) {
        return (List)org.opalj.io.package$.MODULE$.process((Closeable)in2.apply(), (Function1<JarInputStream, List> & Serializable)in -> {
            JarEntry je = in.getNextJarEntry();
            List futures = Nil$.MODULE$;
            while (je != null) {
                String entryName = je.getName();
                if (entryName.endsWith(".class") || entryName.endsWith(".jar")) {
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    byte[] buffer = new byte[32768];
                    ((LazyList)scala.package$.MODULE$.LazyList().continually(() -> in.read(buffer)).takeWhile(x$2 -> x$2 > 0)).foreach(bytesRead -> {
                        baos.write(buffer, 0, bytesRead);
                        baos.flush();
                    });
                    byte[] entryBytes = baos.toByteArray();
                    futures = futures.$colon$colon(Future$.MODULE$.apply((Function0<List> & Serializable)() -> {
                        if (entryName.endsWith(".class")) {
                            List<Object> cfs = this.ClassFile(new DataInputStream(new ByteArrayInputStream(entryBytes)));
                            return cfs.map((Function1<Object, Tuple2> & Serializable)cf -> new Tuple2<Object, String>(cf, entryName));
                        }
                        OPALLogger$.MODULE$.info("class file reader", new StringBuilder(18).append("reading inner jar ").append(entryName).toString(), this.logContext());
                        return this.ClassFiles((Function0<JarInputStream> & Serializable)() -> new JarInputStream(new ByteArrayInputStream(entryBytes)));
                    }, ExecutionContext$.MODULE$.global()));
                }
                je = in.getNextJarEntry();
            }
            return futures.flatMap((Function1<Future, List> & Serializable)f -> (List)Await$.MODULE$.result(f, Duration$.MODULE$.Inf()));
        });
    }

    public static /* synthetic */ void ClassFiles$(ClassFileReader $this, ZipFile zipFile, Function2 classFileHandler, Function2 exceptionHandler) {
        $this.ClassFiles(zipFile, classFileHandler, exceptionHandler);
    }

    default public void ClassFiles(ZipFile zipFile, Function2<Object, URL, BoxedUnit> classFileHandler, Function2<Object, Throwable, BoxedUnit> exceptionHandler) {
        String zipFileURL = new File(zipFile.getName()).toURI().toURL().toExternalForm();
        String jarFileName = new StringBuilder(6).append("jar:").append(zipFileURL).append("!/").toString();
        this.ClassFiles(jarFileName, zipFile, classFileHandler, exceptionHandler);
    }

    private void ClassFiles(String jarFileURL, ZipFile jarFile, Function2<Object, URL, BoxedUnit> classFileHandler, Function2<Object, Throwable, BoxedUnit> exceptionHandler) {
        int futureIndex;
        ConcurrentLinkedQueue innerJarEntries = new ConcurrentLinkedQueue();
        ZipEntry[] jarEntries = (ZipEntry[])CollectionConverters$.MODULE$.EnumerationHasAsScala(jarFile.entries()).asScala().toArray(ClassTag$.MODULE$.apply(ZipEntry.class));
        AtomicInteger nextEntryIndex = new AtomicInteger(jarEntries.length - 1);
        int parallelismLevel = org.opalj.concurrent.package$.MODULE$.NumberOfThreadsForIOBoundTasks();
        Future[] futures = new Future[parallelismLevel];
        for (futureIndex = 0; futureIndex < parallelismLevel; ++futureIndex) {
            futures[futureIndex] = Future$.MODULE$.apply(() -> {
                int index = -1;
                while ((index = nextEntryIndex.getAndDecrement()) >= 0) {
                    Serializable serializable;
                    ZipEntry jarEntry = jarEntries[index];
                    if (!jarEntry.isDirectory() && jarEntry.getSize() > 0L) {
                        String jarEntryName = jarEntry.getName();
                        if (jarEntryName.endsWith(".class")) {
                            try {
                                String path = new StringBuilder(0).append(jarFileURL).append(jarEntryName).toString();
                                URL url = new URI(path.replace(" ", "%20")).toURL();
                                List<Object> classFiles = this.ClassFile(jarFile, jarEntry);
                                classFiles.foreach((Function1<Object, Object> & Serializable)classFile -> {
                                    classFileHandler.apply(classFile, url);
                                    return BoxedUnit.UNIT;
                                });
                                serializable = BoxedUnit.UNIT;
                                continue;
                            }
                            catch (ControlThrowable ct) {
                                throw ct;
                            }
                            catch (Throwable t) {
                                serializable = exceptionHandler.apply(jarEntryName, t);
                                continue;
                            }
                        }
                        if (this.isClassFileRepository(jarEntryName, new Some<String>(jarFile.getName()))) {
                            serializable = BoxesRunTime.boxToBoolean(innerJarEntries.add(jarEntry));
                            continue;
                        }
                        serializable = BoxedUnit.UNIT;
                        continue;
                    }
                    serializable = BoxedUnit.UNIT;
                }
            }, org.opalj.concurrent.package$.MODULE$.OPALHTBoundedExecutionContext());
        }
        while (--futureIndex >= 0) {
            Await$.MODULE$.ready(futures[futureIndex], Duration$.MODULE$.Inf());
        }
        innerJarEntries.iterator().forEachRemaining(jarEntry -> {
            String nextJarFileURL = new StringBuilder(6).append(jarFileURL).append("jar:").append(jarEntry.getName()).append("!/").toString();
            try {
                byte[] jarData = new byte[(int)jarEntry.getSize()];
                DataInputStream din = new DataInputStream(jarFile.getInputStream((ZipEntry)jarEntry));
                din.readFully(jarData);
                din.close();
                this.ClassFiles(nextJarFileURL, jarData, classFileHandler, exceptionHandler);
            }
            catch (ControlThrowable ct) {
                throw ct;
            }
            catch (Throwable t) {
                exceptionHandler.apply(nextJarFileURL, t);
            }
        });
    }

    private void ClassFiles(String jarFileURL, byte[] jarData, Function2<Object, URL, BoxedUnit> classFileHandler, Function2<Object, Throwable, BoxedUnit> exceptionHandler) {
        String pathToEntry = jarFileURL.substring(0, jarFileURL.length() - 2);
        String entry = pathToEntry.substring(pathToEntry.lastIndexOf(47) + 1 + 4);
        try {
            File jarFile = File.createTempFile(entry, ".zip");
            org.opalj.io.package$.MODULE$.process(new FileOutputStream(jarFile), (Function1<FileOutputStream, Object> & Serializable)fout -> {
                fout.write(jarData);
                return BoxedUnit.UNIT;
            });
            this.ClassFiles(jarFileURL, new ZipFile(jarFile), classFileHandler, exceptionHandler);
            jarFile.delete();
        }
        catch (ControlThrowable ct) {
            throw ct;
        }
        catch (Throwable t) {
            exceptionHandler.apply(pathToEntry, t);
        }
    }

    private List<Tuple2<Object, URL>> processJar(File file, Function2<Object, Throwable, BoxedUnit> exceptionHandler) {
        List list;
        try {
            list = (List)org.opalj.io.package$.MODULE$.process(new ZipFile(file), (Function1<ZipFile, List> & Serializable)zf -> this.ClassFiles((ZipFile)zf, exceptionHandler));
        }
        catch (Exception e) {
            exceptionHandler.apply(file, e);
            list = Nil$.MODULE$;
        }
        return list;
    }

    private Function2<Object, Throwable, BoxedUnit> processJar$default$2() {
        return this.defaultExceptionHandler();
    }

    private List<Tuple2<Object, URL>> processClassFile(File file, Function2<Object, Throwable, BoxedUnit> exceptionHandler) {
        List list;
        try {
            list = (List)org.opalj.io.package$.MODULE$.process(new DataInputStream(new BufferedInputStream(new FileInputStream(file))), (Function1<DataInputStream, List> & Serializable)in -> this.ClassFile((DataInputStream)in).map((Function1<Object, Tuple2> & Serializable)classFile -> new Tuple2<Object, URL>(classFile, file.toURI().toURL())));
        }
        catch (Exception e) {
            exceptionHandler.apply(file, e);
            list = Nil$.MODULE$;
        }
        return list;
    }

    private Function2<Object, Throwable, BoxedUnit> processClassFile$default$2() {
        return this.defaultExceptionHandler();
    }

    public static /* synthetic */ List ClassFiles$(ClassFileReader $this, File file, Function2 exceptionHandler) {
        return $this.ClassFiles(file, (Function2<Object, Throwable, BoxedUnit>)exceptionHandler);
    }

    default public List<Tuple2<Object, URL>> ClassFiles(File file, Function2<Object, Throwable, BoxedUnit> exceptionHandler) {
        if (!file.exists()) {
            return Nil$.MODULE$;
        }
        if (file.isFile()) {
            String filename = file.getName();
            if (file.length() == 0L) {
                return Nil$.MODULE$;
            }
            if (this.isClassFileRepository(filename, None$.MODULE$)) {
                return this.processJar(file, this.processJar$default$2());
            }
            if (filename.endsWith(".class")) {
                return this.processClassFile(file, this.processClassFile$default$2());
            }
            return Nil$.MODULE$;
        }
        if (file.isDirectory()) {
            Object jarFiles = ArrayBuffer$.MODULE$.empty();
            Object classFiles = ArrayBuffer$.MODULE$.empty();
            this.collectFiles$1(file.listFiles(), (ArrayBuffer)jarFiles, (ArrayBuffer)classFiles);
            ObjectRef<Object> allClassFiles = ObjectRef.create(scala.package$.MODULE$.List().empty());
            if (((AbstractIterable)classFiles).nonEmpty()) {
                ConcurrentLinkedQueue theClassFiles = new ConcurrentLinkedQueue();
                org.opalj.concurrent.package$.MODULE$.parForeachSeqElement(((AbstractIterable)classFiles).toIndexedSeq(), org.opalj.concurrent.package$.MODULE$.NumberOfThreadsForIOBoundTasks(), org.opalj.concurrent.package$.MODULE$.parForeachSeqElement$default$3(), (Function1<File, Object> & Serializable)classFile -> BoxesRunTime.boxToBoolean(theClassFiles.addAll(CollectionConverters$.MODULE$.SeqHasAsJava(this.processClassFile(classFile, exceptionHandler)).asJava())));
                allClassFiles.elem = (List)((List)allClassFiles.elem).$plus$plus((IterableOnce)CollectionConverters$.MODULE$.CollectionHasAsScala(theClassFiles).asScala());
            }
            ((AbstractIterable)jarFiles).foreach((Function1<File, Object> & Serializable)jarFile -> {
                allClassFiles.elem = (List)((List)allClassFiles.elem).$plus$plus(this.processJar(jarFile, this.processJar$default$2()));
                return BoxedUnit.UNIT;
            });
            return (List)allClassFiles.elem;
        }
        throw new UnknownError(new StringBuilder(34).append(file).append(" is neither a file nor a directory").toString());
    }

    public static /* synthetic */ Function2 ClassFiles$default$2$(ClassFileReader $this) {
        return $this.ClassFiles$default$2();
    }

    default public Function2<Object, Throwable, BoxedUnit> ClassFiles$default$2() {
        return this.defaultExceptionHandler();
    }

    public static /* synthetic */ Iterable AllClassFiles$(ClassFileReader $this, Iterable files2, Function2 exceptionHandler) {
        return $this.AllClassFiles(files2, exceptionHandler);
    }

    default public Iterable<Tuple2<Object, URL>> AllClassFiles(Iterable<File> files2, Function2<Object, Throwable, BoxedUnit> exceptionHandler) {
        return (Iterable)files2.flatMap((Function1<File, List> & Serializable)file -> this.ClassFiles((File)file, exceptionHandler));
    }

    public static /* synthetic */ Function2 AllClassFiles$default$2$(ClassFileReader $this) {
        return $this.AllClassFiles$default$2();
    }

    default public Function2<Object, Throwable, BoxedUnit> AllClassFiles$default$2() {
        return this.defaultExceptionHandler();
    }

    public static /* synthetic */ Iterable JRTClassFiles$(ClassFileReader $this) {
        return $this.JRTClassFiles();
    }

    default public Iterable<Tuple2<String, List<Tuple2<Object, URL>>>> JRTClassFiles() {
        Path allModulesPath = FileSystems.getFileSystem(URI.create("jrt:/")).getPath("/modules", new String[0]);
        return (Iterable)CollectionConverters$.MODULE$.IterableHasAsScala(Files.newDirectoryStream(allModulesPath, "*")).asScala().withFilter((Function1<Path, Object> & Serializable)modulePath -> BoxesRunTime.boxToBoolean(ClassFileReader.$anonfun$JRTClassFiles$4(modulePath))).map((Function1<Path, Tuple2> & Serializable)modulePath -> new Tuple2<String, List>(((Object)modulePath.getFileName()).toString(), this.traverseModule$1((Path)modulePath)));
    }

    public static /* synthetic */ void processClassFiles$(ClassFileReader $this, Iterable files2, Function1 progressReporter, Function1 classFileProcessor, Function2 exceptionHandler) {
        $this.processClassFiles(files2, progressReporter, classFileProcessor, exceptionHandler);
    }

    default public void processClassFiles(Iterable<File> files2, Function1<File, BoxedUnit> progressReporter, Function1<Tuple2<Object, URL>, BoxedUnit> classFileProcessor, Function2<Object, Throwable, BoxedUnit> exceptionHandler) {
        Tasks ts = Tasks$.MODULE$.apply((Function2<Tasks, File, Object> & Serializable)(tasks, file) -> {
            ClassFileReader.$anonfun$processClassFiles$1(this, progressReporter, exceptionHandler, classFileProcessor, tasks, file);
            return BoxedUnit.UNIT;
        }, Tasks$.MODULE$.apply$default$2(), Tasks$.MODULE$.apply$default$3(), org.opalj.concurrent.package$.MODULE$.BoundedExecutionContext("ClassFileReader.processClassFiles", org.opalj.concurrent.package$.MODULE$.NumberOfThreadsForIOBoundTasks()));
        files2.foreach((Function1<File, Object> & Serializable)t -> {
            ts.submit(t);
            return BoxedUnit.UNIT;
        });
        ts.join();
    }

    public static /* synthetic */ Function2 processClassFiles$default$4$(ClassFileReader $this) {
        return $this.processClassFiles$default$4();
    }

    default public Function2<Object, Throwable, BoxedUnit> processClassFiles$default$4() {
        return this.defaultExceptionHandler();
    }

    public static /* synthetic */ Either findClassFile$(ClassFileReader $this, Iterable files2, Function1 progressReporter, Function1 classFileFilter, Function1 className, Function2 exceptionHandler) {
        return $this.findClassFile(files2, progressReporter, classFileFilter, className, exceptionHandler);
    }

    default public Either<Tuple2<Object, URL>, Set<String>> findClassFile(Iterable<File> files2, Function1<File, BoxedUnit> progressReporter, Function1<Object, Object> classFileFilter, Function1<Object, String> className, Function2<Object, Throwable, BoxedUnit> exceptionHandler) {
        Right right;
        Object object = new Object();
        try {
            ObjectRef<Object> classNames = ObjectRef.create(Predef$.MODULE$.Set().empty());
            ((IterableOnceOps)files2.filter((Function1<File, Object> & Serializable)x$3 -> BoxesRunTime.boxToBoolean(x$3.exists()))).foreach((Function1<File, Object> & Serializable)file -> {
                ClassFileReader.$anonfun$findClassFile$2(this, progressReporter, exceptionHandler, classNames, className, classFileFilter, object, file);
                return BoxedUnit.UNIT;
            });
            right = scala.package$.MODULE$.Right().apply((Set)classNames.elem);
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                right = (Right)ex.value();
            }
            throw ex;
        }
        return right;
    }

    public static /* synthetic */ Function2 findClassFile$default$5$(ClassFileReader $this) {
        return $this.findClassFile$default$5();
    }

    default public Function2<Object, Throwable, BoxedUnit> findClassFile$default$5() {
        return this.defaultExceptionHandler();
    }

    private static String unsupportedVersion$1(int major_version$1, int minor_version$1) {
        return new StringBuilder(189).append("unsupported class file version: ").append(major_version$1).append(".").append(minor_version$1).append(" (Supported: 45(Java 1.1) <= version <= ").append(69).append("(").append(package$.MODULE$.jdkVersion(69)).append(")); ").append("analyses might still work, but fail or produce incorrect results when unsupported features are used").toString();
    }

    public static /* synthetic */ boolean $anonfun$ClassFile$5(Tuple2 l, Tuple2 r) {
        return l._1$mcI$sp() < r._1$mcI$sp();
    }

    private static void addClassFile$1(Object cf, URL url, Object Lock$1, ObjectRef classFiles$1) {
        Object object = Lock$1;
        synchronized (object) {
            classFiles$1.elem = ((List)classFiles$1.elem).$colon$colon(new Tuple2<Object, URL>(cf, url));
        }
    }

    private void collectFiles$1(File[] files2, ArrayBuffer jarFiles$1, ArrayBuffer classFiles$2) {
        if (files2 == null) {
            return;
        }
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps(files2), (Function1<File, Object> & Serializable)file -> {
            String filename = file.getName();
            if (file.isFile()) {
                if (file.length() == 0L) {
                    return Nil$.MODULE$;
                }
                if (this.isClassFileRepository(filename, None$.MODULE$)) {
                    return jarFiles$1.$plus$eq(file);
                }
                if (filename.endsWith(".class")) {
                    return classFiles$2.$plus$eq(file);
                }
                return BoxedUnit.UNIT;
            }
            if (file.isDirectory()) {
                this.collectFiles$1(file.listFiles(), jarFiles$1, classFiles$2);
                return BoxedUnit.UNIT;
            }
            OPALLogger$.MODULE$.info("class file reader", new StringBuilder(46).append("ignored: ").append(file).append(" it is neither a file nor a directory").toString(), this.logContext());
            return BoxedUnit.UNIT;
        });
    }

    private void traversePath$1(Path p, ObjectRef allClassFiles$2) {
        if (Files.isDirectory(p, new LinkOption[0])) {
            try {
                CollectionConverters$.MODULE$.IterableHasAsScala(Files.newDirectoryStream(p, "*")).asScala().foreach((Function1<Path, Object> & Serializable)subPath -> {
                    this.traversePath$1(subPath, allClassFiles$2);
                    return BoxedUnit.UNIT;
                });
            }
            catch (Exception e) {
                OPALLogger$.MODULE$.error("class file reader", "failed processing Java 9+ Runtime Image (jrt:/)", e, this.logContext());
            }
            return;
        }
        if (((Object)p.getFileName()).toString().endsWith(".class")) {
            List<Object> cf = this.ClassFile((Function0<InputStream> & Serializable)() -> Files.newInputStream(p, new OpenOption[0]));
            Object object = cf.map((Function1<Object, Tuple2> & Serializable)c -> new Tuple2<Object, URL>(c, p.toUri().toURL()));
            allClassFiles$2.elem = (List)((List)allClassFiles$2.elem).$plus$plus$colon((IterableOnce)object);
            return;
        }
    }

    private List traverseModule$1(Path module) {
        ObjectRef<Object> allClassFiles = ObjectRef.create(scala.package$.MODULE$.List().empty());
        this.traversePath$1(module, allClassFiles);
        return (List)allClassFiles.elem;
    }

    public static /* synthetic */ boolean $anonfun$JRTClassFiles$4(Path modulePath) {
        return Files.isDirectory(modulePath, new LinkOption[0]);
    }

    public static /* synthetic */ void $anonfun$processClassFiles$1(ClassFileReader $this, Function1 progressReporter$1, Function2 exceptionHandler$5, Function1 classFileProcessor$1, Tasks tasks, File file) {
        if (file.isFile() && file.length() > 0L) {
            String filename = file.getName();
            if ($this.isClassFileRepository(filename, None$.MODULE$)) {
                if (!filename.endsWith("-javadoc.jar") && !filename.endsWith("-sources.jar")) {
                    progressReporter$1.apply(file);
                    $this.processJar(file, exceptionHandler$5).foreach(classFileProcessor$1);
                    return;
                }
                return;
            }
            if (filename.endsWith(".class")) {
                progressReporter$1.apply(file);
                $this.processClassFile(file, exceptionHandler$5).foreach(classFileProcessor$1);
                return;
            }
            return;
        }
        if (file.isDirectory()) {
            progressReporter$1.apply(file);
            ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps(file.listFiles()), (Function1<File, Object> & Serializable)t -> {
                tasks.submit(t);
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    public static /* synthetic */ boolean $anonfun$findClassFile$3(ObjectRef classNames$1, Function1 className$1, Function1 classFileFilter$1, Tuple2 cfSource) {
        Tuple2 tuple2 = cfSource;
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Object cf = tuple2._1();
        Object cf2 = cf;
        classNames$1.elem = (Set)((Set)classNames$1.elem).$plus(className$1.apply(cf2));
        return BoxesRunTime.unboxToBoolean(classFileFilter$1.apply(cf2));
    }

    public static /* synthetic */ void $anonfun$findClassFile$6(ClassFileReader $this, Function1 progressReporter$2, Function1 classFileFilter$1, Function1 className$1, Function2 exceptionHandler$6, Object nonLocalReturnKey1$1, ObjectRef classNames$1, File f) {
        Either<Tuple2<Object, URL>, Set<String>> either = $this.findClassFile(new $colon$colon<Nothing$>((Nothing$)((Object)f), Nil$.MODULE$), progressReporter$2, classFileFilter$1, className$1, exceptionHandler$6);
        if (either instanceof Left) {
            Left left = (Left)either;
            Tuple2 cf = (Tuple2)left.value();
            throw new NonLocalReturnControl(nonLocalReturnKey1$1, scala.package$.MODULE$.Left().apply(cf));
        }
        if (either instanceof Right) {
            Right right = (Right)either;
            Set moreClassNames = (Set)right.value();
            classNames$1.elem = (Set)((Set)classNames$1.elem).$plus$plus(moreClassNames);
            return;
        }
        throw new MatchError(either);
    }

    public static /* synthetic */ void $anonfun$findClassFile$2(ClassFileReader $this, Function1 progressReporter$2, Function2 exceptionHandler$6, ObjectRef classNames$1, Function1 className$1, Function1 classFileFilter$1, Object nonLocalReturnKey1$1, File file) {
        if (file.isFile() && file.length() > 0L) {
            List list;
            String filename = file.getName();
            if ($this.isClassFileRepository(filename, None$.MODULE$)) {
                if (!filename.endsWith("-javadoc.jar") && !filename.endsWith("-sources.jar")) {
                    progressReporter$2.apply(file);
                    list = $this.processJar(file, exceptionHandler$6);
                } else {
                    list = Nil$.MODULE$;
                }
            } else if (filename.endsWith(".class")) {
                progressReporter$2.apply(file);
                list = $this.processClassFile(file, exceptionHandler$6);
            } else {
                list = Nil$.MODULE$;
            }
            ((List)list.filter((Function1<Tuple2, Object> & Serializable)cfSource -> BoxesRunTime.boxToBoolean(ClassFileReader.$anonfun$findClassFile$3(classNames$1, className$1, classFileFilter$1, cfSource)))).foreach((Function1<Tuple2, Nothing$> & Serializable)e -> {
                throw new NonLocalReturnControl(nonLocalReturnKey1$1, scala.package$.MODULE$.Left().apply(e));
            });
            return;
        }
        if (file.isDirectory()) {
            ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps(file.listFiles((dir, name) -> dir.isDirectory() || $this.isClassFileRepository(file.toString(), None$.MODULE$))), (Function1<File, Object> & Serializable)f -> {
                ClassFileReader.$anonfun$findClassFile$6($this, progressReporter$2, classFileFilter$1, className$1, exceptionHandler$6, nonLocalReturnKey1$1, classNames$1, f);
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    public static void $init$(ClassFileReader $this) {
        $this.org$opalj$bi$reader$ClassFileReader$_setter_$defaultExceptionHandler_$eq((Function2<Object, Throwable, BoxedUnit>)(Function2<Object, Throwable, Object> & Serializable)(source, t) -> {
            OPALLogger$.MODULE$.error("class file reader", new StringBuilder(18).append("processing ").append(source).append(" failed").toString(), t, $this.logContext());
            return BoxedUnit.UNIT;
        });
        $this.org$opalj$bi$reader$ClassFileReader$$classFilePostProcessors_$eq(ArraySeq$.MODULE$.empty(ClassTag$.MODULE$.apply(Function1.class)));
    }
}

